/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.text;

import java.awt.event.ActionEvent;
import org.freeplane.core.ui.AMultipleNodeAction;
import org.freeplane.core.ui.SelectableAction;
import org.freeplane.features.map.IMapSelection;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.text.ShortenedTextModel;
import org.freeplane.features.text.TextController;

@SelectableAction(checkOnNodeChange=true)
class SetShortenerStateAction
extends AMultipleNodeAction {
    private static final long serialVersionUID = 1L;
    private boolean setShortened;

    public SetShortenerStateAction() {
        super("SetShortenerStateAction");
    }

    public void actionPerformed(ActionEvent e) {
        this.setShortened = !this.isShortened();
        IMapSelection selection = Controller.getCurrentController().getSelection();
        selection.keepNodePosition(selection.getSelected(), 0.5f, 0.5f);
        super.actionPerformed(e);
    }

    private boolean isShortened() {
        NodeModel node = Controller.getCurrentModeController().getMapController().getSelectedNode();
        if (node == null) {
            return false;
        }
        ShortenedTextModel model = ShortenedTextModel.getShortenedTextModel(node);
        return model != null;
    }

    protected void actionPerformed(ActionEvent e, NodeModel node) {
        TextController controller = TextController.getController();
        controller.setIsMinimized(node, this.setShortened);
    }

    public void setSelected() {
        this.setSelected(this.isShortened());
    }
}

