/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.text;

import java.util.regex.PatternSyntaxException;
import javax.swing.ComboBoxEditor;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import org.freeplane.core.resources.NamedObject;
import org.freeplane.core.ui.FixedBasicComboBoxEditor;
import org.freeplane.core.ui.components.TypedListCellRenderer;
import org.freeplane.core.ui.components.UITools;
import org.freeplane.core.util.HtmlUtils;
import org.freeplane.core.util.TextUtils;
import org.freeplane.features.filter.condition.ASelectableCondition;
import org.freeplane.features.filter.condition.IElementaryConditionController;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.note.NoteModel;
import org.freeplane.features.text.DetailTextModel;
import org.freeplane.features.text.MatchCaseNodeContainsCondition;
import org.freeplane.features.text.MatchCaseNoteContainsCondition;
import org.freeplane.features.text.NodeContainsCondition;
import org.freeplane.features.text.NodeMatchesRegexpCondition;
import org.freeplane.features.text.NodeTextCompareCondition;
import org.freeplane.features.text.NoteContainsCondition;
import org.freeplane.features.text.TextController;
import org.freeplane.features.ui.FrameController;
import org.freeplane.n3.nanoxml.XMLElement;

class NodeTextConditionController
implements IElementaryConditionController {
    private final ComboBoxModel values = new DefaultComboBoxModel();

    NodeTextConditionController() {
    }

    public boolean canEditValues(Object selectedItem, NamedObject simpleCond) {
        return true;
    }

    public boolean canHandle(Object selectedItem) {
        if (!(selectedItem instanceof NamedObject)) {
            return false;
        }
        NamedObject namedObject = (NamedObject)selectedItem;
        return namedObject.objectEquals("filter_node") || namedObject.objectEquals("filter_parent") || namedObject.objectEquals("filter_details") || namedObject.objectEquals("filter_note") || namedObject.objectEquals("filter_any_text");
    }

    public boolean canSelectValues(Object selectedItem, NamedObject simpleCond) {
        return true;
    }

    public ASelectableCondition createCondition(Object selectedItem, NamedObject simpleCondition, Object value, boolean matchCase, boolean matchApproximately) {
        String item = (String)((NamedObject)selectedItem).getObject();
        return this.createASelectableCondition(item, simpleCondition, value, matchCase, matchApproximately);
    }

    private ASelectableCondition createASelectableCondition(String item, NamedObject simpleCondition, Object value, boolean matchCase, boolean matchApproximately) {
        if (simpleCondition.objectEquals("filter_contains")) {
            if (value.equals("")) {
                return null;
            }
            return matchCase ? new MatchCaseNodeContainsCondition(item, value.toString(), matchApproximately) : new NodeContainsCondition(item, value.toString(), matchApproximately);
        }
        if (simpleCondition.objectEquals("filter_regexp_matches")) {
            try {
                return new NodeMatchesRegexpCondition(item, value.toString(), matchCase);
            }
            catch (PatternSyntaxException e) {
                UITools.errorMessage(TextUtils.format("wrong_regexp", value, e.getMessage()));
                return null;
            }
        }
        if (simpleCondition.objectEquals("filter_is_equal_to")) {
            return new NodeTextCompareCondition(item, value, matchCase, 0, true, matchApproximately);
        }
        if (simpleCondition.objectEquals("filter_is_not_equal_to")) {
            return new NodeTextCompareCondition(item, value, matchCase, 0, false, matchApproximately);
        }
        if (simpleCondition.objectEquals(">")) {
            return new NodeTextCompareCondition(item, value, matchCase, 1, true, matchApproximately);
        }
        if (simpleCondition.objectEquals(">=")) {
            return new NodeTextCompareCondition(item, value, matchCase, -1, false, matchApproximately);
        }
        if (simpleCondition.objectEquals("<")) {
            return new NodeTextCompareCondition(item, value, matchCase, -1, true, matchApproximately);
        }
        if (simpleCondition.objectEquals("<=")) {
            return new NodeTextCompareCondition(item, value, matchCase, 1, false, matchApproximately);
        }
        return null;
    }

    public ComboBoxModel getConditionsForProperty(Object selectedItem) {
        return new DefaultComboBoxModel<NamedObject>(new NamedObject[]{TextUtils.createTranslatedString("filter_contains"), TextUtils.createTranslatedString("filter_is_equal_to"), TextUtils.createTranslatedString("filter_is_not_equal_to"), NamedObject.literal(">"), NamedObject.literal(">="), NamedObject.literal("<="), NamedObject.literal("<"), TextUtils.createTranslatedString("filter_regexp_matches")});
    }

    public ListModel getFilteredProperties() {
        DefaultListModel<NamedObject> list = new DefaultListModel<NamedObject>();
        list.addElement(TextUtils.createTranslatedString("filter_any_text"));
        list.addElement(TextUtils.createTranslatedString("filter_node"));
        list.addElement(TextUtils.createTranslatedString("filter_details"));
        list.addElement(TextUtils.createTranslatedString("filter_note"));
        list.addElement(TextUtils.createTranslatedString("filter_parent"));
        return list;
    }

    public ComboBoxEditor getValueEditor(Object selectedProperty, NamedObject selectedCondition) {
        if (selectedCondition.objectEquals("filter_contains") || selectedCondition.objectEquals("filter_regexp_matches")) {
            return new FixedBasicComboBoxEditor();
        }
        return FrameController.getTextDateTimeEditor();
    }

    public ComboBoxModel getValuesForProperty(Object selectedItem, NamedObject simpleCond) {
        return this.values;
    }

    public boolean isCaseDependent(Object selectedItem, NamedObject simpleCond) {
        return true;
    }

    public boolean supportsApproximateMatching(Object selectedItem, NamedObject simpleCond) {
        return true;
    }

    public ASelectableCondition loadCondition(XMLElement element) {
        if (element.getName().equalsIgnoreCase("node_contains_condition")) {
            return NodeContainsCondition.load(element);
        }
        if (element.getName().equalsIgnoreCase("match_case_node_contains_condition")) {
            return MatchCaseNodeContainsCondition.load(element);
        }
        if (element.getName().equalsIgnoreCase("node_compare_condition")) {
            return NodeTextCompareCondition.load(element);
        }
        if (element.getName().equalsIgnoreCase("node_matches_regexp")) {
            return NodeMatchesRegexpCondition.load(element);
        }
        if (element.getName().equalsIgnoreCase("note_contains_condition")) {
            return NoteContainsCondition.load(element);
        }
        if (element.getName().equalsIgnoreCase("match_case_note_contains_condition")) {
            return MatchCaseNoteContainsCondition.load(element);
        }
        return null;
    }

    public static Object[] getItemsForComparison(Object nodeItem, NodeModel node) {
        if (nodeItem.equals("filter_any_text")) {
            return new Object[]{NodeTextConditionController.getItemForComparison("filter_node", node), NodeTextConditionController.getItemForComparison("filter_details", node), NodeTextConditionController.getItemForComparison("filter_note", node)};
        }
        return new Object[]{NodeTextConditionController.getItemForComparison(nodeItem, node)};
    }

    private static Object getItemForComparison(Object nodeItem, NodeModel node) {
        NodeModel parentNode;
        Object result = nodeItem.equals("filter_node") ? TextController.getController().getTransformedObjectNoThrow(node) : (nodeItem.equals("filter_parent") ? ((parentNode = node.getParentNode()) == null ? null : TextController.getController().getTransformedObjectNoThrow(parentNode)) : (nodeItem.equals("filter_details") ? DetailTextModel.getDetailTextText(node) : (nodeItem.equals("filter_note") ? NoteModel.getNoteText(node) : null)));
        if (result instanceof String) {
            return HtmlUtils.htmlToPlain((String)result);
        }
        return result;
    }

    public ListCellRenderer getValueRenderer(Object selectedProperty, NamedObject selectedCondition) {
        if (selectedCondition.objectEquals("filter_contains") || selectedCondition.objectEquals("filter_regexp_matches")) {
            return null;
        }
        return new TypedListCellRenderer();
    }
}

