/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.text;

import java.util.regex.Pattern;
import org.freeplane.core.io.xml.TreeXmlWriter;
import org.freeplane.core.util.TextUtils;
import org.freeplane.features.filter.condition.ASelectableCondition;
import org.freeplane.features.filter.condition.ConditionFactory;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.text.NodeTextConditionController;
import org.freeplane.n3.nanoxml.XMLElement;

public class NodeMatchesRegexpCondition
extends ASelectableCondition {
    static final String NAME = "node_matches_regexp";
    static final String SEARCH_PATTERN = "SEARCH_PATTERN";
    private final Pattern searchPattern;
    private final String nodeItem;

    static ASelectableCondition load(XMLElement element) {
        Boolean matchCase = Boolean.valueOf(element.getAttribute("MATCH_CASE", "false"));
        String searchPattern = element.getAttribute(SEARCH_PATTERN, null);
        String nodeItem = element.getAttribute("ITEM", "filter_node");
        return new NodeMatchesRegexpCondition(nodeItem, searchPattern, matchCase);
    }

    public NodeMatchesRegexpCondition(String nodeItem, String searchPattern) {
        this(nodeItem, searchPattern, false);
    }

    public NodeMatchesRegexpCondition(String nodeItem, String searchPattern, boolean matchCase) {
        int flags = 32;
        if (!matchCase) {
            flags |= 2;
        }
        this.searchPattern = Pattern.compile(searchPattern, flags);
        this.nodeItem = nodeItem;
    }

    public boolean checkNode(NodeModel node) {
        Object[] content = NodeTextConditionController.getItemsForComparison(this.nodeItem, node);
        return content != null && this.checkText(content);
    }

    private boolean checkText(Object[] content) {
        for (Object o : content) {
            if (o == null || !this.checkText(o.toString())) continue;
            return true;
        }
        return false;
    }

    private boolean checkText(String text) {
        return this.searchPattern.matcher(text).find();
    }

    protected String createDescription() {
        String nodeCondition = TextUtils.getText(this.nodeItem);
        String simpleCondition = TextUtils.getText("filter_regexp_matches");
        return ConditionFactory.createDescription(nodeCondition, simpleCondition, this.searchPattern.pattern(), this.isMatchCase(), false);
    }

    public void fillXML(XMLElement child) {
        super.fillXML(child);
        child.setAttribute(SEARCH_PATTERN, this.searchPattern.pattern());
        child.setAttribute("MATCH_CASE", TreeXmlWriter.BooleanToXml(this.isMatchCase()));
        child.setAttribute("ITEM", this.nodeItem);
    }

    private boolean isMatchCase() {
        return (this.searchPattern.flags() & 2) == 0;
    }

    protected String getName() {
        return NAME;
    }
}

