/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.text;

import org.freeplane.core.util.HtmlUtils;
import org.freeplane.core.util.TextUtils;
import org.freeplane.features.filter.ExactStringMatchingStrategy;
import org.freeplane.features.filter.StringMatchingStrategy;
import org.freeplane.features.filter.condition.ASelectableCondition;
import org.freeplane.features.filter.condition.ConditionFactory;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.note.NoteModel;
import org.freeplane.n3.nanoxml.XMLElement;

public class MatchCaseNoteContainsCondition
extends ASelectableCondition {
    static final String NAME = "match_case_note_contains_condition";
    static final String VALUE = "VALUE";
    static final String MATCH_APPROXIMATELY = "MATCH_APPROXIMATELY";
    private final String value;
    final boolean matchApproximately;
    final StringMatchingStrategy stringMatchingStrategy;

    static ASelectableCondition load(XMLElement element) {
        return new MatchCaseNoteContainsCondition(element.getAttribute(VALUE, null), Boolean.valueOf(element.getAttribute(MATCH_APPROXIMATELY, null)));
    }

    protected boolean matchCase() {
        return true;
    }

    MatchCaseNoteContainsCondition(String value, boolean matchApproximately) {
        this.value = value;
        this.matchApproximately = matchApproximately;
        this.stringMatchingStrategy = matchApproximately ? StringMatchingStrategy.DEFAULT_APPROXIMATE_STRING_MATCHING_STRATEGY : new ExactStringMatchingStrategy();
    }

    public boolean checkNode(NodeModel node) {
        String text = this.getText(node);
        if (text == null) {
            return false;
        }
        return this.stringMatchingStrategy.matches(this.value, text, true, this.matchCase());
    }

    protected String createDescription() {
        return this.createDescription(true);
    }

    protected String createDescription(boolean matchCase) {
        String nodeCondition = TextUtils.getText("filter_note");
        String simpleCondition = TextUtils.getText("filter_contains");
        return ConditionFactory.createDescription(nodeCondition, simpleCondition, this.value, matchCase, this.matchApproximately);
    }

    protected String getText(NodeModel node) {
        String noteText = NoteModel.getNoteText(node);
        return noteText == null ? null : HtmlUtils.htmlToPlain(noteText);
    }

    public void fillXML(XMLElement child) {
        super.fillXML(child);
        child.setAttribute(VALUE, this.value);
        child.setAttribute(MATCH_APPROXIMATELY, Boolean.toString(this.matchApproximately));
    }

    protected String getName() {
        return NAME;
    }
}

