/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.text;

import org.freeplane.core.util.TextUtils;
import org.freeplane.features.filter.ExactStringMatchingStrategy;
import org.freeplane.features.filter.StringMatchingStrategy;
import org.freeplane.features.filter.condition.ASelectableCondition;
import org.freeplane.features.filter.condition.ConditionFactory;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.text.NodeTextConditionController;
import org.freeplane.n3.nanoxml.XMLElement;

public class MatchCaseNodeContainsCondition
extends ASelectableCondition {
    static final String NAME = "match_case_node_contains_condition";
    static final String VALUE = "VALUE";
    static final String MATCH_APPROXIMATELY = "MATCH_APPROXIMATELY";
    private final String value;
    private final String nodeItem;
    private final boolean matchApproximately;
    private final StringMatchingStrategy stringMatchingStrategy;

    static ASelectableCondition load(XMLElement element) {
        return new MatchCaseNodeContainsCondition(element.getAttribute("ITEM", "filter_node"), element.getAttribute(VALUE, null), Boolean.valueOf(element.getAttribute(MATCH_APPROXIMATELY, null)));
    }

    MatchCaseNodeContainsCondition(String nodeItem, String value, boolean matchApproximately) {
        this.value = value;
        this.nodeItem = nodeItem;
        this.matchApproximately = matchApproximately;
        this.stringMatchingStrategy = matchApproximately ? StringMatchingStrategy.DEFAULT_APPROXIMATE_STRING_MATCHING_STRATEGY : new ExactStringMatchingStrategy();
    }

    public boolean checkNode(NodeModel node) {
        Object[] content = NodeTextConditionController.getItemsForComparison(this.nodeItem, node);
        return this.checkText(content);
    }

    private boolean checkText(Object[] content) {
        for (Object o : content) {
            if (!this.checkText(o)) continue;
            return true;
        }
        return false;
    }

    private boolean checkText(Object o) {
        return o != null && this.stringMatchingStrategy.matches(this.value, o.toString(), true, true);
    }

    protected String createDescription() {
        String nodeCondition = TextUtils.getText(this.nodeItem);
        String simpleCondition = TextUtils.getText("filter_contains");
        return ConditionFactory.createDescription(nodeCondition, simpleCondition, this.value, true, this.matchApproximately);
    }

    public void fillXML(XMLElement child) {
        super.fillXML(child);
        child.setAttribute(VALUE, this.value);
        child.setAttribute("ITEM", this.nodeItem);
        child.setAttribute(MATCH_APPROXIMATELY, Boolean.toString(this.matchApproximately));
    }

    protected String getName() {
        return NAME;
    }
}

