/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.styles;

import java.util.Collection;
import org.freeplane.core.util.TextUtils;
import org.freeplane.features.filter.condition.ASelectableCondition;
import org.freeplane.features.filter.condition.ConditionFactory;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.styles.IStyle;
import org.freeplane.features.styles.LogicalStyleController;
import org.freeplane.features.styles.StyleNamedObject;
import org.freeplane.features.styles.StyleString;
import org.freeplane.n3.nanoxml.XMLElement;

public class StyleContainsCondition
extends ASelectableCondition {
    static final String NAME = "style_contains_condition";
    private final Object value;

    public StyleContainsCondition(IStyle value) {
        this.value = value;
    }

    public boolean checkNode(NodeModel node) {
        Collection<IStyle> styles = LogicalStyleController.getController().getStyles(node);
        return styles.contains(this.value);
    }

    public void fillXML(XMLElement child) {
        if (this.value instanceof StyleString) {
            child.setAttribute("TEXT", this.value.toString());
        } else if (this.value instanceof StyleNamedObject) {
            child.setAttribute("LOCALIZED_TEXT", ((StyleNamedObject)this.value).getObject().toString());
        }
    }

    public static ASelectableCondition load(XMLElement element) {
        String text = element.getAttribute("TEXT", null);
        if (text != null) {
            return new StyleContainsCondition(new StyleString(text));
        }
        String name = element.getAttribute("LOCALIZED_TEXT", null);
        if (name != null) {
            return new StyleContainsCondition(new StyleNamedObject(name));
        }
        return null;
    }

    protected String createDescription() {
        String style = TextUtils.getText("filter_style");
        String simpleCondition = TextUtils.getText("filter_contains");
        return ConditionFactory.createDescription(style, simpleCondition, this.value.toString(), false, false);
    }

    protected String getName() {
        return NAME;
    }
}

