/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.styles;

import org.freeplane.core.util.TextUtils;
import org.freeplane.features.filter.condition.ASelectableCondition;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.styles.IStyle;
import org.freeplane.features.styles.LogicalStyleController;
import org.freeplane.features.styles.StyleNamedObject;
import org.freeplane.features.styles.StyleString;
import org.freeplane.n3.nanoxml.XMLElement;

public class StyleCondition
extends ASelectableCondition {
    static final String NAME = "style_equals_condition";
    private final Object value;

    public StyleCondition(IStyle value) {
        this.value = value;
    }

    public boolean checkNode(NodeModel node) {
        IStyle firstStyle = LogicalStyleController.getController().getFirstStyle(node);
        return this.value.equals(firstStyle);
    }

    public void fillXML(XMLElement child) {
        if (this.value instanceof StyleString) {
            child.setAttribute("TEXT", this.value.toString());
        } else if (this.value instanceof StyleNamedObject) {
            child.setAttribute("LOCALIZED_TEXT", ((StyleNamedObject)this.value).getObject().toString());
        }
    }

    public static ASelectableCondition load(XMLElement element) {
        String text = element.getAttribute("TEXT", null);
        if (text != null) {
            return new StyleCondition(new StyleString(text));
        }
        String name = element.getAttribute("LOCALIZED_TEXT", null);
        if (name != null) {
            return new StyleCondition(new StyleNamedObject(name));
        }
        return null;
    }

    protected String createDescription() {
        String filterStyle = TextUtils.getText("filter_style");
        return filterStyle + " '" + this.value.toString() + '\'';
    }

    protected String getName() {
        return NAME;
    }
}

