/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.styles;

import java.awt.Color;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.event.ListDataListener;
import org.freeplane.core.extension.IExtension;
import org.freeplane.core.undo.IUndoHandler;
import org.freeplane.features.cloud.CloudModel;
import org.freeplane.features.edge.EdgeModel;
import org.freeplane.features.edge.EdgeStyle;
import org.freeplane.features.map.MapModel;
import org.freeplane.features.map.MapReader;
import org.freeplane.features.map.MapWriter;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.mode.ModeController;
import org.freeplane.features.nodestyle.NodeSizeModel;
import org.freeplane.features.styles.ConditionalStyleModel;
import org.freeplane.features.styles.IStyle;
import org.freeplane.features.styles.MapViewLayout;
import org.freeplane.features.styles.StyleMapModel;
import org.freeplane.features.styles.StyleNamedObject;
import org.freeplane.features.styles.StyleNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapStyleModel
implements IExtension {
    public static final String STYLES_PREDEFINED = "styles.predefined";
    public static final IStyle DEFAULT_STYLE = new StyleNamedObject("default");
    public static final IStyle DETAILS_STYLE = new StyleNamedObject("defaultstyle.details");
    public static final IStyle NOTE_STYLE = new StyleNamedObject("defaultstyle.note");
    public static final IStyle FLOATING_STYLE = new StyleNamedObject("defaultstyle.floating");
    private Map<IStyle, NodeModel> styleNodes;
    private MapModel styleMap;
    private ConditionalStyleModel conditionalStyleModel;
    private final DefaultComboBoxModel stylesComboBoxModel;
    private final Map<String, String> properties;
    private Color backgroundColor;
    private float zoom = 1.0f;
    private MapViewLayout mapViewLayout = MapViewLayout.MAP;
    private int maxNodeWidth = -1;
    private int minNodeWidth = -1;
    ArrayList<ListDataListener> listeners = new ArrayList();
    public static final String STYLES_USER_DEFINED = "styles.user-defined";

    Map<String, String> getProperties() {
        return this.properties;
    }

    public static MapStyleModel getExtension(MapModel map) {
        return MapStyleModel.getExtension(map.getRootNode());
    }

    public MapModel getStyleMap() {
        return this.styleMap;
    }

    public static MapStyleModel getExtension(NodeModel node) {
        return node.getExtension(MapStyleModel.class);
    }

    public MapStyleModel() {
        this.conditionalStyleModel = new ConditionalStyleModel();
        this.styleNodes = new LinkedHashMap<IStyle, NodeModel>();
        this.properties = new LinkedHashMap<String, String>();
        this.stylesComboBoxModel = new DefaultComboBoxModel();
    }

    public ConditionalStyleModel getConditionalStyleModel() {
        return this.conditionalStyleModel;
    }

    private void insertStyleMap(MapModel map, MapModel styleMap) {
        this.styleMap = styleMap;
        NodeModel rootNode = styleMap.getRootNode();
        this.createNodeStyleMap(rootNode);
        styleMap.putExtension(IUndoHandler.class, map.getExtension(IUndoHandler.class));
        MapStyleModel defaultStyleModel = new MapStyleModel();
        defaultStyleModel.styleNodes = this.styleNodes;
        this.initStylesComboBoxModel();
        rootNode.putExtension(defaultStyleModel);
    }

    public void refreshStyles() {
        NodeModel rootNode = this.styleMap.getRootNode();
        this.styleNodes.clear();
        this.stylesComboBoxModel.removeAllElements();
        this.createNodeStyleMap(rootNode);
    }

    void createStyleMap(MapModel parentMap, MapStyleModel mapStyleModel, String styleMapStr) {
        ModeController modeController = Controller.getCurrentModeController();
        StyleMapModel styleMap = new StyleMapModel();
        styleMap.createNewRoot();
        MapReader mapReader = modeController.getMapController().getMapReader();
        StringReader styleReader = new StringReader(styleMapStr);
        try {
            NodeModel newNode;
            HashMap<Object, Object> hints = new HashMap<Object, Object>();
            hints.put((Object)MapWriter.Hint.MODE, (Object)MapWriter.Mode.FILE);
            hints.put("folding_loaded", Boolean.TRUE);
            NodeModel root = mapReader.createNodeTreeFromXml((MapModel)styleMap, (Reader)styleReader, hints);
            styleMap.setRoot(root);
            this.insertStyleMap(parentMap, styleMap);
            NodeModel predefinedStyleParentNode = this.getStyleNodeGroup(styleMap, STYLES_PREDEFINED);
            if (predefinedStyleParentNode == null) {
                predefinedStyleParentNode = new NodeModel(styleMap);
                predefinedStyleParentNode.setUserObject(new StyleNamedObject(STYLES_PREDEFINED));
                root.insert(predefinedStyleParentNode);
            }
            if (this.styleNodes.get(DEFAULT_STYLE) == null) {
                NodeModel newNode2 = new NodeModel(DEFAULT_STYLE, styleMap);
                predefinedStyleParentNode.insert(newNode2, 0);
                this.addStyleNode(newNode2);
            }
            NodeModel defaultStyleModel = this.styleNodes.get(DEFAULT_STYLE);
            if (this.maxNodeWidth != -1 && -1 == NodeSizeModel.getNodeMaxNodeWidth(defaultStyleModel)) {
                NodeSizeModel.setNodeMaxNodeWidth(defaultStyleModel, this.maxNodeWidth);
            }
            if (this.minNodeWidth != -1 && -1 == NodeSizeModel.getMinNodeWidth(defaultStyleModel)) {
                NodeSizeModel.setNodeMinWidth(defaultStyleModel, this.minNodeWidth);
            }
            if (this.styleNodes.get(DETAILS_STYLE) == null) {
                newNode = new NodeModel(DETAILS_STYLE, styleMap);
                predefinedStyleParentNode.insert(newNode, 1);
                this.addStyleNode(newNode);
            }
            if (this.styleNodes.get(NOTE_STYLE) == null) {
                newNode = new NodeModel(NOTE_STYLE, styleMap);
                predefinedStyleParentNode.insert(newNode, 2);
                this.addStyleNode(newNode);
            }
            if (this.styleNodes.get(FLOATING_STYLE) == null) {
                newNode = new NodeModel(FLOATING_STYLE, styleMap);
                EdgeModel.createEdgeModel(newNode).setStyle(EdgeStyle.EDGESTYLE_HIDDEN);
                CloudModel.createModel(newNode).setShape(CloudModel.Shape.ROUND_RECT);
                predefinedStyleParentNode.insert(newNode, 3);
                this.addStyleNode(newNode);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void createNodeStyleMap(NodeModel node) {
        if (node.hasChildren()) {
            Enumeration<NodeModel> children = node.children();
            while (children.hasMoreElements()) {
                this.createNodeStyleMap(children.nextElement());
            }
            return;
        }
        if (node.depth() >= 2) {
            this.addStyleNode(node);
        }
    }

    public void addStyleNode(NodeModel node) {
        IStyle userObject = (IStyle)node.getUserObject();
        if (null == this.styleNodes.put(userObject, node)) {
            this.stylesComboBoxModel.addElement(userObject);
        }
    }

    private void initStylesComboBoxModel() {
        this.stylesComboBoxModel.removeAllElements();
        for (IStyle s : this.getStyles()) {
            this.stylesComboBoxModel.addElement(s);
        }
    }

    public void removeStyleNode(NodeModel node) {
        Object userObject = node.getUserObject();
        if (null != this.styleNodes.remove(userObject)) {
            this.stylesComboBoxModel.removeElement(userObject);
        }
    }

    public NodeModel getStyleNodeSafe(IStyle style) {
        NodeModel node = this.getStyleNode(style);
        if (node != null) {
            return node;
        }
        return this.getStyleNode(DEFAULT_STYLE);
    }

    public NodeModel getStyleNode(IStyle style) {
        if (style instanceof StyleNode) {
            return ((StyleNode)style).getNode();
        }
        NodeModel node = this.styleNodes.get(style);
        return node;
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setBackgroundColor(Color backgroundColor) {
        this.backgroundColor = backgroundColor;
    }

    public Set<IStyle> getStyles() {
        return this.styleNodes.keySet();
    }

    public float getZoom() {
        return this.zoom;
    }

    public MapViewLayout getMapViewLayout() {
        return this.mapViewLayout;
    }

    void setMapViewLayout(MapViewLayout mapViewLayout) {
        this.mapViewLayout = mapViewLayout;
    }

    void setZoom(float zoom) {
        this.zoom = zoom;
    }

    public void setMaxNodeWidth(int maxNodeWidth) {
        this.maxNodeWidth = maxNodeWidth;
    }

    public void setMinNodeWidth(int minNodeWidth) {
        this.minNodeWidth = minNodeWidth;
    }

    void copyFrom(MapStyleModel source, boolean overwrite) {
        if (overwrite && source.styleMap != null || this.styleMap == null) {
            this.styleMap = source.styleMap;
            this.styleNodes = source.styleNodes;
            this.initStylesComboBoxModel();
            this.conditionalStyleModel = source.conditionalStyleModel;
        }
        if (overwrite && source.backgroundColor != null || this.backgroundColor == null) {
            this.backgroundColor = source.backgroundColor;
        }
    }

    public void setProperty(String key, String value) {
        if (value != null) {
            this.properties.put(key, value);
        } else {
            this.properties.remove(key);
        }
    }

    public String getProperty(String key) {
        return this.properties.get(key);
    }

    public NodeModel getStyleNodeGroup(NodeModel styleNode) {
        int depth = styleNode.depth();
        if (depth < 1) {
            return null;
        }
        NodeModel node = styleNode;
        for (int i = depth; i > 1; --i) {
            node = node.getParentNode();
        }
        return node;
    }

    public NodeModel getStyleNodeGroup(MapModel styleMap, String group) {
        NodeModel rootNode = styleMap.getRootNode();
        int childCount = rootNode.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            NodeModel childNode = (NodeModel)rootNode.getChildAt(i);
            StyleNamedObject userObject = (StyleNamedObject)childNode.getUserObject();
            if (!userObject.getObject().equals(group)) continue;
            return childNode;
        }
        return null;
    }

    ComboBoxModel getStylesAsComboBoxModel() {
        return this.stylesComboBoxModel;
    }
}

