/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.styles;

import java.awt.Color;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.net.URL;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import org.freeplane.core.extension.IExtension;
import org.freeplane.core.io.IElementContentHandler;
import org.freeplane.core.io.IElementDOMHandler;
import org.freeplane.core.io.IElementHandler;
import org.freeplane.core.io.IExtensionElementWriter;
import org.freeplane.core.io.ITreeWriter;
import org.freeplane.core.resources.NamedObject;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.core.ui.components.UITools;
import org.freeplane.core.undo.IActor;
import org.freeplane.core.undo.IUndoHandler;
import org.freeplane.core.util.ColorUtils;
import org.freeplane.core.util.Compat;
import org.freeplane.core.util.LogUtils;
import org.freeplane.core.util.TextUtils;
import org.freeplane.features.filter.FilterController;
import org.freeplane.features.filter.condition.ASelectableCondition;
import org.freeplane.features.filter.condition.ConditionFactory;
import org.freeplane.features.map.IMapLifeCycleListener;
import org.freeplane.features.map.MapChangeEvent;
import org.freeplane.features.map.MapController;
import org.freeplane.features.map.MapModel;
import org.freeplane.features.map.MapWriter;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.mode.ModeController;
import org.freeplane.features.mode.NodeHookDescriptor;
import org.freeplane.features.mode.PersistentNodeHook;
import org.freeplane.features.styles.ConditionalStyleModel;
import org.freeplane.features.styles.IStyle;
import org.freeplane.features.styles.LogicalStyleController;
import org.freeplane.features.styles.MapStyleModel;
import org.freeplane.features.styles.MapViewLayout;
import org.freeplane.features.styles.StyleFactory;
import org.freeplane.features.url.UrlManager;
import org.freeplane.n3.nanoxml.XMLElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NodeHookDescriptor(hookName="MapStyle")
public class MapStyle
extends PersistentNodeHook
implements IExtension,
IMapLifeCycleListener {
    private static final String NODE_CONDITIONAL_STYLES = "NodeConditionalStyles";
    public static final String RESOURCES_BACKGROUND_COLOR = "standardbackgroundcolor";
    public static final String MAP_STYLES = "MAP_STYLES";

    public static void install(boolean persistent) {
        new MapStyle(persistent);
    }

    protected MapStyle(boolean persistent) {
        MapController mapController;
        ModeController modeController = Controller.getCurrentModeController();
        if (persistent) {
            mapController = modeController.getMapController();
            mapController.getWriteManager().addExtensionElementWriter(this.getExtensionClass(), new XmlWriter());
            mapController.getReadManager().addElementHandler("conditional_styles", new IElementDOMHandler(){

                public Object createElement(Object parent, String tag, XMLElement attributes) {
                    return parent;
                }

                public void endElement(Object parent, String tag, Object element, XMLElement dom) {
                    NodeModel node = (NodeModel)parent;
                    MapStyleModel mapStyleModel = MapStyleModel.getExtension(node);
                    if (mapStyleModel != null) {
                        MapStyle.this.loadConditionalStyles(mapStyleModel.getConditionalStyleModel(), dom);
                    }
                }
            });
            mapController.getWriteManager().addExtensionElementWriter(ConditionalStyleModel.class, new IExtensionElementWriter(){

                public void writeContent(ITreeWriter writer, Object element, IExtension extension) throws IOException {
                    ConditionalStyleModel conditionalStyleModel = (ConditionalStyleModel)extension;
                    if (conditionalStyleModel.getStyleCount() == 0) {
                        return;
                    }
                    XMLElement hook = new XMLElement("hook");
                    hook.setAttribute("NAME", MapStyle.NODE_CONDITIONAL_STYLES);
                    MapStyle.this.saveConditionalStyles(conditionalStyleModel, hook, false);
                    writer.addElement(null, hook);
                }
            });
            mapController.getReadManager().addElementHandler("hook", new IElementDOMHandler(){

                public Object createElement(Object parent, String tag, XMLElement attributes) {
                    if (attributes == null || !MapStyle.NODE_CONDITIONAL_STYLES.equals(attributes.getAttribute("NAME", null))) {
                        return null;
                    }
                    ConditionalStyleModel conditionalStyleModel = new ConditionalStyleModel();
                    ((NodeModel)parent).addExtension(conditionalStyleModel);
                    return conditionalStyleModel;
                }

                public void endElement(Object parent, String tag, Object element, XMLElement dom) {
                    MapStyle.this.loadConditionalStyles((ConditionalStyleModel)element, dom);
                }
            });
            mapController.getReadManager().addElementHandler("map_styles", new IElementContentHandler(){

                public Object createElement(Object parent, String tag, XMLElement attributes) {
                    return parent;
                }

                public void endElement(Object parent, String tag, Object userObject, XMLElement attributes, String content) {
                    if (this.isContentEmpty(content)) {
                        return;
                    }
                    NodeModel node = (NodeModel)userObject;
                    MapStyleModel mapStyleModel = MapStyleModel.getExtension(node);
                    if (mapStyleModel == null) {
                        return;
                    }
                    MapModel map = node.getMap();
                    mapStyleModel.createStyleMap(map, mapStyleModel, content);
                    map.getIconRegistry().addIcons(mapStyleModel.getStyleMap());
                }

                private boolean isContentEmpty(String content) {
                    return content.indexOf(60) == -1;
                }
            });
        }
        modeController.getMapController().addMapLifeCycleListener(this);
        mapController = modeController.getMapController();
        mapController.addMapLifeCycleListener(this);
    }

    @Override
    protected XmlWriter createXmlWriter() {
        return null;
    }

    @Override
    protected IElementHandler createXmlReader() {
        return new MyXmlReader();
    }

    @Override
    protected IExtension createExtension(NodeModel node, XMLElement element) {
        MapStyleModel model = new MapStyleModel();
        String colorString = element.getAttribute("background", null);
        Color bgColor = colorString != null ? ColorUtils.stringToColor(colorString) : null;
        model.setBackgroundColor(bgColor);
        String zoomString = element.getAttribute("zoom", null);
        if (zoomString != null) {
            float zoom = Float.valueOf(zoomString).floatValue();
            model.setZoom(zoom);
        }
        String layoutString = element.getAttribute("layout", null);
        try {
            if (layoutString != null) {
                MapViewLayout layout = MapViewLayout.valueOf(layoutString);
                model.setMapViewLayout(layout);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        String maxNodeWidthString = element.getAttribute("max_node_width", null);
        String minNodeWidthString = element.getAttribute("min_node_width", null);
        try {
            if (maxNodeWidthString != null) {
                int maxNodeWidth = Integer.valueOf(maxNodeWidthString);
                model.setMaxNodeWidth(maxNodeWidth);
            }
            if (minNodeWidthString != null) {
                int minNodeWidth = Integer.valueOf(minNodeWidthString);
                model.setMinNodeWidth(minNodeWidth);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return model;
    }

    private void loadConditionalStyles(ConditionalStyleModel conditionalStyleModel, XMLElement conditionalStylesRoot) {
        ConditionFactory conditionFactory = FilterController.getCurrentFilterController().getConditionFactory();
        Vector<XMLElement> styleElements = conditionalStylesRoot.getChildrenNamed("conditional_style");
        for (XMLElement styleElement : styleElements) {
            ASelectableCondition condition;
            IStyle style;
            boolean isLast;
            boolean isActive;
            block4: {
                isActive = Boolean.valueOf(styleElement.getAttribute("ACTIVE", "false"));
                isLast = Boolean.valueOf(styleElement.getAttribute("LAST", "false"));
                String styleText = styleElement.getAttribute("LOCALIZED_STYLE_REF", null);
                style = styleText != null ? StyleFactory.create(NamedObject.format(styleText)) : StyleFactory.create(styleElement.getAttribute("STYLE_REF", null));
                if (styleElement.getChildrenCount() == 1) {
                    XMLElement conditionElement = styleElement.getChildAtIndex(0);
                    try {
                        condition = conditionFactory.loadCondition(conditionElement);
                        break block4;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        continue;
                    }
                }
                condition = null;
            }
            conditionalStyleModel.addCondition(isActive, condition, style, isLast);
        }
    }

    private void saveConditionalStyles(ConditionalStyleModel conditionalStyleModel, XMLElement parent, boolean createRoot) {
        XMLElement conditionalStylesRoot;
        int styleCount = conditionalStyleModel.getStyleCount();
        if (styleCount == 0) {
            return;
        }
        if (createRoot) {
            conditionalStylesRoot = parent.createElement("conditional_styles");
            parent.addChild(conditionalStylesRoot);
        } else {
            conditionalStylesRoot = parent;
        }
        for (ConditionalStyleModel.Item item : conditionalStyleModel) {
            item.toXml(conditionalStylesRoot);
        }
    }

    public Color getBackground(MapModel map) {
        Color backgroundColor;
        MapStyleModel extension = map.getRootNode().getExtension(MapStyleModel.class);
        Color color = backgroundColor = extension != null ? extension.getBackgroundColor() : null;
        if (backgroundColor != null) {
            return backgroundColor;
        }
        String stdcolor = ResourceController.getResourceController().getProperty(RESOURCES_BACKGROUND_COLOR);
        Color standardMapBackgroundColor = ColorUtils.stringToColor(stdcolor);
        return standardMapBackgroundColor;
    }

    protected Class<MapStyleModel> getExtensionClass() {
        return MapStyleModel.class;
    }

    @Override
    public void onCreate(MapModel map) {
        NodeModel rootNode = map.getRootNode();
        MapStyleModel mapStyleModel = MapStyleModel.getExtension(rootNode);
        if (mapStyleModel != null && mapStyleModel.getStyleMap() != null) {
            return;
        }
        this.createDefaultStyleMap(map);
    }

    private void createDefaultStyleMap(MapModel map) {
        MapModel styleMapContainer;
        UrlManager loader = UrlManager.getController();
        File file = loader.defaultTemplateFile();
        if (file != null) {
            try {
                styleMapContainer = new MapModel();
                loader.load(Compat.fileToUrl(file), styleMapContainer);
                if (null != MapStyleModel.getExtension(styleMapContainer)) {
                    this.moveStyle(styleMapContainer, map, false);
                    return;
                }
            }
            catch (Exception e) {
                LogUtils.warn(e);
                UITools.errorMessage(TextUtils.format("error_in_template", file));
            }
        }
        styleMapContainer = new MapModel();
        try {
            loader.load(ResourceController.getResourceController().getResource("/styles/viewer_standard.mm"), styleMapContainer);
            this.moveStyle(styleMapContainer, map, false);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void moveStyle(MapModel sourceMap, MapModel targetMap, boolean overwrite) {
        MapStyleModel source = sourceMap.getRootNode().removeExtension(MapStyleModel.class);
        if (source == null) {
            return;
        }
        IUndoHandler undoHandler = targetMap.getExtension(IUndoHandler.class);
        source.getStyleMap().putExtension(IUndoHandler.class, undoHandler);
        NodeModel targetRoot = targetMap.getRootNode();
        MapStyleModel target = MapStyleModel.getExtension(targetRoot);
        if (target == null) {
            targetRoot.addExtension(source);
        } else {
            target.copyFrom(source, overwrite);
        }
    }

    @Override
    protected PersistentNodeHook.HookAction createHookAction() {
        return null;
    }

    public void copyStyle(URL source, final MapModel targetMap, boolean undoable) {
        MapModel styleMapContainer = new MapModel();
        final MapStyleModel oldStyleModel = targetMap.getRootNode().removeExtension(MapStyleModel.class);
        UrlManager.getController().loadCatchExceptions(source, styleMapContainer);
        this.onCreate(styleMapContainer);
        this.moveStyle(styleMapContainer, targetMap, true);
        LogicalStyleController.getController().refreshMap(targetMap);
        if (!undoable) {
            return;
        }
        final MapStyleModel newStyleModel = targetMap.getRootNode().getExtension(MapStyleModel.class);
        IActor actor = new IActor(){

            public void undo() {
                targetMap.getRootNode().putExtension(oldStyleModel);
            }

            public String getDescription() {
                return "moveStyle";
            }

            public void act() {
                targetMap.getRootNode().putExtension(newStyleModel);
            }
        };
        Controller.getCurrentModeController().execute(actor, targetMap);
    }

    @Override
    public void onRemove(MapModel map) {
    }

    @Override
    protected void saveExtension(IExtension extension, XMLElement element) {
        MapViewLayout layout;
        float zoom;
        MapStyleModel mapStyleModel = (MapStyleModel)extension;
        super.saveExtension(extension, element);
        Color backgroundColor = mapStyleModel.getBackgroundColor();
        if (backgroundColor != null) {
            element.setAttribute("background", ColorUtils.colorToString(backgroundColor));
        }
        if ((zoom = mapStyleModel.getZoom()) != 1.0f) {
            element.setAttribute("zoom", Float.toString(zoom));
        }
        if (!(layout = mapStyleModel.getMapViewLayout()).equals((Object)MapViewLayout.MAP)) {
            element.setAttribute("layout", layout.toString());
        }
        this.saveConditionalStyles(mapStyleModel.getConditionalStyleModel(), element, true);
        this.saveProperties(mapStyleModel.getProperties(), element);
    }

    private void saveProperties(Map<String, String> properties, XMLElement element) {
        if (properties.isEmpty()) {
            return;
        }
        XMLElement xmlElement = new XMLElement("properties");
        for (Map.Entry<String, String> entry : properties.entrySet()) {
            xmlElement.setAttribute(entry.getKey(), entry.getValue());
        }
        element.addChild(xmlElement);
    }

    public void setZoom(MapModel map, float zoom) {
        MapStyleModel mapStyleModel = MapStyleModel.getExtension(map);
        if (zoom == mapStyleModel.getZoom()) {
            return;
        }
        mapStyleModel.setZoom(zoom);
        Controller.getCurrentModeController().getMapController().setSaved(map, false);
    }

    public void setMapViewLayout(MapModel map, MapViewLayout layout) {
        MapStyleModel mapStyleModel = MapStyleModel.getExtension(map);
        if (layout.equals((Object)mapStyleModel.getMapViewLayout())) {
            return;
        }
        mapStyleModel.setMapViewLayout(layout);
        Controller.getCurrentModeController().getMapController().setSaved(map, false);
    }

    public void setBackgroundColor(final MapStyleModel model, final Color actionColor) {
        final Color oldColor = model.getBackgroundColor();
        if (actionColor == oldColor || actionColor != null && actionColor.equals(oldColor)) {
            return;
        }
        IActor actor = new IActor(){

            public void act() {
                model.setBackgroundColor(actionColor);
                Controller.getCurrentModeController().getMapController().fireMapChanged(new MapChangeEvent(MapStyle.this, Controller.getCurrentController().getMap(), MapStyle.RESOURCES_BACKGROUND_COLOR, oldColor, actionColor));
            }

            public String getDescription() {
                return "MapStyle.setBackgroundColor";
            }

            public void undo() {
                model.setBackgroundColor(oldColor);
                Controller.getCurrentModeController().getMapController().fireMapChanged(new MapChangeEvent(MapStyle.this, Controller.getCurrentController().getMap(), MapStyle.RESOURCES_BACKGROUND_COLOR, actionColor, oldColor));
            }
        };
        Controller.getCurrentModeController().execute(actor, Controller.getCurrentController().getMap());
    }

    public static MapStyle getController(ModeController modeController) {
        return modeController.getExtension(MapStyle.class);
    }

    public static MapStyle getController() {
        return MapStyle.getController(Controller.getCurrentModeController());
    }

    public void setProperty(final MapModel model, final String key, final String newValue) {
        final MapStyleModel styleModel = MapStyleModel.getExtension(model);
        final String oldValue = styleModel.getProperty(key);
        if (oldValue == newValue || oldValue != null && oldValue.equals(newValue)) {
            return;
        }
        IActor actor = new IActor(){

            public void undo() {
                this.setPropertyWithoutUndo(model, key, oldValue);
            }

            public String getDescription() {
                return "set map style property";
            }

            public void act() {
                this.setPropertyWithoutUndo(model, key, newValue);
            }

            private void setPropertyWithoutUndo(MapModel model2, String key2, String newValue2) {
                styleModel.setProperty(key2, newValue2);
                Controller.getCurrentModeController().getMapController().fireMapChanged(new MapChangeEvent(MapStyle.this, model2, key2, oldValue, newValue2));
            }
        };
        Controller.getCurrentModeController().execute(actor, model);
    }

    public String getPropertySetDefault(MapModel model, String key) {
        MapStyleModel styleModel = MapStyleModel.getExtension(model);
        String oldValue = styleModel.getProperty(key);
        if (oldValue != null) {
            return oldValue;
        }
        String value = ResourceController.getResourceController().getProperty(key);
        styleModel.setProperty(key, value);
        return value;
    }

    public String getProperty(MapModel model, String key) {
        return MapStyleModel.getExtension(model).getProperty(key);
    }

    public Map<String, String> getPropertiesReadOnly(MapModel model) {
        return Collections.unmodifiableMap(MapStyleModel.getExtension(model).getProperties());
    }

    protected class MyXmlReader
    extends PersistentNodeHook.XmlReader {
        protected MyXmlReader() {
        }

        public Object createElement(Object parent, String tag, XMLElement attributes) {
            if (null == super.createElement(parent, tag, attributes)) {
                return null;
            }
            super.endElement(parent, tag, parent, attributes);
            return parent;
        }

        public void endElement(Object parent, String tag, Object userObject, XMLElement xml) {
            XMLElement parentNodeElement = xml.getParent().getParent();
            if (parentNodeElement == null || !parentNodeElement.getName().equals("map")) {
                return;
            }
            NodeModel node = (NodeModel)userObject;
            this.loadMapStyleProperties(MapStyleModel.getExtension(node), xml);
        }

        private void loadMapStyleProperties(MapStyleModel model, XMLElement xml) {
            Vector<XMLElement> propertyXml = xml.getChildrenNamed("properties");
            if (propertyXml != null && propertyXml.size() >= 1) {
                Map<String, String> properties = model.getProperties();
                Properties attributes = propertyXml.get(0).getAttributes();
                for (Map.Entry<Object, Object> attribute : attributes.entrySet()) {
                    properties.put(attribute.getKey().toString(), attribute.getValue().toString());
                }
            }
        }
    }

    protected class XmlWriter
    implements IExtensionElementWriter {
        protected XmlWriter() {
        }

        public void writeContent(ITreeWriter writer, Object object, IExtension extension) throws IOException {
            MapStyleModel mapStyleModel = (MapStyleModel)extension;
            MapModel styleMap = mapStyleModel.getStyleMap();
            String el = System.getProperty("line.separator");
            if (styleMap == null) {
                return;
            }
            MapWriter mapWriter = Controller.getCurrentModeController().getMapController().getMapWriter();
            StringWriter sw = new StringWriter();
            sw.append(el);
            sw.append("<map_styles>");
            sw.append(el);
            NodeModel rootNode = styleMap.getRootNode();
            boolean forceFormatting = Boolean.TRUE.equals(writer.getHint((Object)MapWriter.WriterHint.FORCE_FORMATTING));
            try {
                mapWriter.writeNodeAsXml(sw, rootNode, MapWriter.Mode.STYLE, true, true, forceFormatting);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            sw.append("</map_styles>");
            sw.append(el);
            XMLElement element = new XMLElement("hook");
            MapStyle.this.saveExtension(extension, element);
            writer.addElement((Object)sw.toString(), element);
        }
    }
}

