/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.styles;

import java.awt.Component;
import java.awt.EventQueue;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import org.freeplane.core.extension.IExtension;
import org.freeplane.core.io.IAttributeHandler;
import org.freeplane.core.io.IAttributeWriter;
import org.freeplane.core.io.ITreeWriter;
import org.freeplane.core.io.ReadManager;
import org.freeplane.core.io.WriteManager;
import org.freeplane.core.resources.NamedObject;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.core.undo.IActor;
import org.freeplane.core.util.HtmlUtils;
import org.freeplane.core.util.TextUtils;
import org.freeplane.features.filter.condition.ASelectableCondition;
import org.freeplane.features.map.IMapChangeListener;
import org.freeplane.features.map.INodeChangeListener;
import org.freeplane.features.map.ITooltipProvider;
import org.freeplane.features.map.MapChangeEvent;
import org.freeplane.features.map.MapController;
import org.freeplane.features.map.MapModel;
import org.freeplane.features.map.NodeChangeEvent;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.mode.CombinedPropertyChain;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.mode.IPropertyHandler;
import org.freeplane.features.mode.ModeController;
import org.freeplane.features.styles.ConditionalStyleModel;
import org.freeplane.features.styles.IStyle;
import org.freeplane.features.styles.LogicalStyleModel;
import org.freeplane.features.styles.MapStyleModel;
import org.freeplane.features.styles.StyleFactory;
import org.freeplane.features.styles.StyleNamedObject;
import org.freeplane.features.styles.StyleNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LogicalStyleController
implements IExtension {
    private static final int STYLE_TOOLTIP = 0;
    private WeakReference<NodeModel> cachedNode;
    private Collection<IStyle> cachedStyle;
    private final CombinedPropertyChain<Collection<IStyle>, NodeModel> styleHandlers = new CombinedPropertyChain(false);
    private static Map<MapModel, Integer> mapsToRefresh = new HashMap<MapModel, Integer>();

    public LogicalStyleController(ModeController modeController) {
        this.createBuilder();
        this.registerChangeListener();
        this.addStyleGetter(IPropertyHandler.NODE, new IPropertyHandler<Collection<IStyle>, NodeModel>(){

            @Override
            public Collection<IStyle> getProperty(NodeModel node, Collection<IStyle> currentValue) {
                MapStyleModel styleModel = MapStyleModel.getExtension(node.getMap());
                LogicalStyleController.this.add(node, styleModel, currentValue, new StyleNode(node));
                return currentValue;
            }
        });
        this.addStyleGetter(IPropertyHandler.STYLE, new IPropertyHandler<Collection<IStyle>, NodeModel>(){

            @Override
            public Collection<IStyle> getProperty(NodeModel node, Collection<IStyle> currentValue) {
                IStyle style = LogicalStyleModel.getStyle(node);
                if (style != null) {
                    LogicalStyleController.this.add(node, currentValue, style);
                }
                MapStyleModel styleModel = MapStyleModel.getExtension(node.getMap());
                Collection<IStyle> condStyles = styleModel.getConditionalStyleModel().getStyles(node);
                LogicalStyleController.this.clearCache();
                LogicalStyleController.this.addAll(node, styleModel, currentValue, condStyles);
                return currentValue;
            }
        });
        this.addStyleGetter(IPropertyHandler.DEFAULT, new IPropertyHandler<Collection<IStyle>, NodeModel>(){

            @Override
            public Collection<IStyle> getProperty(NodeModel node, Collection<IStyle> currentValue) {
                LogicalStyleController.this.add(node, currentValue, MapStyleModel.DEFAULT_STYLE);
                return currentValue;
            }
        });
        modeController.addToolTipProvider(0, new ITooltipProvider(){

            public String getTooltip(ModeController modeController, NodeModel node, Component view) {
                if (!ResourceController.getResourceController().getBooleanProperty("show_styles_in_tooltip")) {
                    return null;
                }
                Collection<IStyle> styles = LogicalStyleController.this.getStyles(node);
                if (styles.size() > 0) {
                    styles.remove(styles.iterator().next());
                }
                String label = TextUtils.getText("node_styles");
                return HtmlUtils.plainToHTML(label + ": " + LogicalStyleController.this.getStyleNames(styles, ", "));
            }
        });
    }

    protected Collection<IStyle> getResursively(NodeModel node, Collection<IStyle> collection) {
        MapStyleModel styleModel = MapStyleModel.getExtension(node.getMap());
        LinkedHashSet<IStyle> set = new LinkedHashSet<IStyle>();
        this.addAll(node, styleModel, set, collection);
        return set;
    }

    protected void addAll(NodeModel node, MapStyleModel styleModel, Collection<IStyle> currentValue, Collection<IStyle> collection) {
        for (IStyle styleKey : collection) {
            this.add(node, styleModel, currentValue, styleKey);
        }
    }

    public void add(NodeModel node, Collection<IStyle> currentValue, IStyle style) {
        MapStyleModel styleModel = MapStyleModel.getExtension(node.getMap());
        this.add(node, styleModel, currentValue, style);
    }

    protected void add(NodeModel node, MapStyleModel styleModel, Collection<IStyle> currentValue, IStyle styleKey) {
        ConditionalStyleModel conditionalStyleModel;
        IStyle style;
        if (!currentValue.add(styleKey)) {
            return;
        }
        NodeModel styleNode = styleModel.getStyleNode(styleKey);
        if (styleNode == null) {
            return;
        }
        if (styleKey instanceof StyleNode && (style = LogicalStyleModel.getStyle(styleNode)) != null) {
            this.add(node, styleModel, currentValue, style);
        }
        if ((conditionalStyleModel = styleNode.getExtension(ConditionalStyleModel.class)) == null) {
            return;
        }
        Collection<IStyle> styles = conditionalStyleModel.getStyles(node);
        this.cachedNode = null;
        this.addAll(node, styleModel, currentValue, styles);
    }

    private void registerChangeListener() {
        ModeController modeController = Controller.getCurrentModeController();
        MapController mapController = modeController.getMapController();
        mapController.addMapChangeListener(new IMapChangeListener(){

            public void onPreNodeMoved(NodeModel oldParent, int oldIndex, NodeModel newParent, NodeModel child, int newIndex) {
                LogicalStyleController.this.clearCache();
            }

            public void onPreNodeDelete(NodeModel oldParent, NodeModel selectedNode, int index) {
                LogicalStyleController.this.clearCache();
            }

            public void onNodeMoved(NodeModel oldParent, int oldIndex, NodeModel newParent, NodeModel child, int newIndex) {
                LogicalStyleController.this.clearCache();
            }

            public void onNodeInserted(NodeModel parent, NodeModel child, int newIndex) {
                LogicalStyleController.this.clearCache();
            }

            public void onNodeDeleted(NodeModel parent, NodeModel child, int index) {
                LogicalStyleController.this.clearCache();
            }

            public void mapChanged(MapChangeEvent event) {
                LogicalStyleController.this.clearCache();
            }
        });
        mapController.addNodeChangeListener(new INodeChangeListener(){

            public void nodeChanged(NodeChangeEvent event) {
                LogicalStyleController.this.clearCache();
            }
        });
    }

    private void createBuilder() {
        ModeController modeController = Controller.getCurrentModeController();
        MapController mapController = modeController.getMapController();
        ReadManager readManager = mapController.getReadManager();
        readManager.addAttributeHandler("node", "STYLE_REF", new IAttributeHandler(){

            public void setAttribute(Object node, String value) {
                LogicalStyleModel extension = LogicalStyleModel.createExtension((NodeModel)node);
                extension.setStyle(StyleFactory.create(value));
            }
        });
        readManager.addAttributeHandler("node", "LOCALIZED_STYLE_REF", new IAttributeHandler(){

            public void setAttribute(Object node, String value) {
                LogicalStyleModel extension = LogicalStyleModel.createExtension((NodeModel)node);
                extension.setStyle(StyleFactory.create(NamedObject.format(value)));
            }
        });
        WriteManager writeManager = mapController.getWriteManager();
        writeManager.addAttributeWriter("node", new IAttributeWriter(){

            public void writeAttributes(ITreeWriter writer, Object node, String tag) {
                LogicalStyleModel extension = LogicalStyleModel.getExtension((NodeModel)node);
                if (extension == null) {
                    return;
                }
                IStyle style = extension.getStyle();
                if (style == null) {
                    return;
                }
                String value = StyleNamedObject.toKeyString(style);
                if (style instanceof StyleNamedObject) {
                    writer.addAttribute("LOCALIZED_STYLE_REF", value);
                } else {
                    writer.addAttribute("STYLE_REF", value);
                }
            }
        });
    }

    public static void install(LogicalStyleController logicalStyleController) {
        ModeController modeController = Controller.getCurrentModeController();
        modeController.addExtension(LogicalStyleController.class, logicalStyleController);
    }

    public static LogicalStyleController getController() {
        ModeController modeController = Controller.getCurrentModeController();
        return LogicalStyleController.getController(modeController);
    }

    public static LogicalStyleController getController(ModeController modeController) {
        return modeController.getExtension(LogicalStyleController.class);
    }

    public void refreshMap(final MapModel map) {
        IActor actor = new IActor(){

            public void undo() {
                LogicalStyleController.this.refreshMapLater(map);
            }

            public String getDescription() {
                return "refreshMap";
            }

            public void act() {
                LogicalStyleController.this.refreshMapLater(map);
            }
        };
        Controller.getCurrentModeController().execute(actor, map);
    }

    private void refreshMapLater(final MapModel map) {
        Integer count = mapsToRefresh.get(map);
        if (count == null) {
            mapsToRefresh.put(map, 0);
        } else {
            mapsToRefresh.put(map, count + 1);
        }
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                Integer count = (Integer)mapsToRefresh.get(map);
                if (count > 0) {
                    mapsToRefresh.put(map, count - 1);
                    return;
                }
                mapsToRefresh.remove(map);
                MapStyleModel extension = MapStyleModel.getExtension(map);
                extension.refreshStyles();
                MapController mapController = Controller.getCurrentModeController().getMapController();
                mapController.fireMapChanged(new MapChangeEvent(this, map, "MAP_STYLES", null, null));
            }
        });
    }

    public IStyle getFirstStyle(NodeModel node) {
        Collection<IStyle> styles = this.getStyles(node);
        boolean found = false;
        for (IStyle style : styles) {
            if (found) {
                return style;
            }
            if (!(style instanceof StyleNode)) continue;
            found = true;
        }
        return MapStyleModel.DEFAULT_STYLE;
    }

    public Collection<IStyle> getStyles(NodeModel node) {
        if (this.cachedNode != null && node.equals(this.cachedNode.get())) {
            return this.cachedStyle;
        }
        this.cachedStyle = null;
        this.cachedStyle = this.styleHandlers.getProperty(node, new LinkedHashSet());
        this.cachedNode = new WeakReference<NodeModel>(node);
        return this.cachedStyle;
    }

    public void moveConditionalStyleDown(ConditionalStyleModel conditionalStyleModel, int index) {
        conditionalStyleModel.moveDown(index);
    }

    public void moveConditionalStyleUp(ConditionalStyleModel conditionalStyleModel, int index) {
        conditionalStyleModel.moveUp(index);
    }

    public void addConditionalStyle(ConditionalStyleModel conditionalStyleModel, boolean isActive, ASelectableCondition condition, IStyle style, boolean isLast) {
        conditionalStyleModel.addCondition(isActive, condition, style, isLast);
    }

    public void insertConditionalStyle(ConditionalStyleModel conditionalStyleModel, int index, boolean isActive, ASelectableCondition condition, IStyle style, boolean isLast) {
        conditionalStyleModel.insertCondition(index, isActive, condition, style, isLast);
    }

    public ConditionalStyleModel.Item removeConditionalStyle(ConditionalStyleModel conditionalStyleModel, int index) {
        return conditionalStyleModel.removeCondition(index);
    }

    private void clearCache() {
        this.cachedStyle = null;
        this.cachedNode = null;
    }

    public IPropertyHandler<Collection<IStyle>, NodeModel> addStyleGetter(Integer key, IPropertyHandler<Collection<IStyle>, NodeModel> getter) {
        return this.styleHandlers.addGetter(key, getter);
    }

    public IPropertyHandler<Collection<IStyle>, NodeModel> removeStyleGetter(Integer key, IPropertyHandler<Collection<IStyle>, NodeModel> getter) {
        return this.styleHandlers.addGetter(key, getter);
    }

    public String getStyleNames(Collection<IStyle> styles, String separator) {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        for (IStyle style : styles) {
            if (i > 0) {
                sb.append(separator);
            }
            sb.append(style.toString());
            ++i;
        }
        return sb.toString();
    }

    public Collection<IStyle> getConditionalMapStyles(NodeModel node) {
        MapStyleModel styleModel = MapStyleModel.getExtension(node.getMap());
        Collection<IStyle> condStyles = styleModel.getConditionalStyleModel().getStyles(node);
        this.clearCache();
        return this.getResursively(node, condStyles);
    }

    public Collection<IStyle> getConditionalNodeStyles(NodeModel node) {
        ConditionalStyleModel conditionalStyleModel;
        LinkedHashSet<IStyle> condStyles = new LinkedHashSet<IStyle>();
        IStyle style = LogicalStyleModel.getStyle(node);
        if (style != null) {
            condStyles.add(style);
        }
        if ((conditionalStyleModel = node.getExtension(ConditionalStyleModel.class)) != null) {
            Collection<IStyle> styles = conditionalStyleModel.getStyles(node);
            this.clearCache();
            condStyles.addAll(styles);
        }
        Collection<IStyle> all = this.getResursively(node, condStyles);
        if (style != null) {
            all.remove(style);
        }
        return all;
    }

    public String getNodeStyleNames(NodeModel node, String separator) {
        return this.getStyleNames(this.getConditionalNodeStyles(node), separator);
    }

    public String getMapStyleNames(NodeModel node, String separator) {
        return this.getStyleNames(this.getConditionalMapStyles(node), separator);
    }
}

