/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.styles;

import java.util.Collection;
import org.freeplane.core.extension.IExtension;
import org.freeplane.core.resources.NamedObject;
import org.freeplane.features.map.MapModel;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.mode.IPropertyHandler;
import org.freeplane.features.mode.NodeHookDescriptor;
import org.freeplane.features.mode.PersistentNodeHook;
import org.freeplane.features.mode.mindmapmode.MModeController;
import org.freeplane.features.styles.AutomaticLayout;
import org.freeplane.features.styles.IStyle;
import org.freeplane.features.styles.LogicalStyleController;
import org.freeplane.features.styles.MapStyleModel;
import org.freeplane.features.styles.StyleFactory;
import org.freeplane.n3.nanoxml.XMLElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NodeHookDescriptor(hookName="accessories/plugins/AutomaticLayout.properties")
public class AutomaticLayoutController
extends PersistentNodeHook
implements IExtension {
    public AutomaticLayoutController() {
        LogicalStyleController.getController().addStyleGetter(IPropertyHandler.AUTO, new IPropertyHandler<Collection<IStyle>, NodeModel>(){

            @Override
            public Collection<IStyle> getProperty(NodeModel model, Collection<IStyle> currentValue) {
                AutomaticLayout layout = model.getMap().getRootNode().getExtension(AutomaticLayout.class);
                IStyle autoStyle = AutomaticLayoutController.this.getStyle(model, layout);
                if (autoStyle != null) {
                    LogicalStyleController.getController().add(model, currentValue, autoStyle);
                }
                return currentValue;
            }
        });
    }

    @Override
    protected IExtension createExtension(NodeModel node, XMLElement element) {
        if (element == null || !element.hasAttribute("VALUE")) {
            return AutomaticLayout.ALL;
        }
        return super.createExtension(node, element);
    }

    private IStyle getStyle(NodeModel node, AutomaticLayout layout) {
        String name;
        NamedObject obj;
        IStyle style;
        if (layout == null || node.isLeaf() && !layout.equals(AutomaticLayout.ALL)) {
            return null;
        }
        int depth = node.depth();
        MapModel map = node.getMap();
        MapStyleModel extension = MapStyleModel.getExtension(map);
        if (extension.getStyleNode(style = StyleFactory.create(obj = NamedObject.format(name = depth == 0 ? "AutomaticLayout.level.root" : "AutomaticLayout.level," + depth))) != null) {
            return style;
        }
        return null;
    }

    @Override
    protected Class<? extends IExtension> getExtensionClass() {
        return AutomaticLayout.class;
    }

    @Override
    protected IExtension toggle(NodeModel node, IExtension extension) {
        extension = super.toggle(node, extension);
        MModeController modeController = (MModeController)Controller.getCurrentModeController();
        if (modeController.isUndoAction()) {
            return extension;
        }
        LogicalStyleController.getController().refreshMap(node.getMap());
        return extension;
    }
}

