/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.print;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.core.ui.MenuBuilder;
import org.freeplane.core.ui.components.UITools;
import org.freeplane.core.util.TextUtils;
import org.freeplane.features.print.AbstractPrintAction;
import org.freeplane.features.print.FitMap;
import org.freeplane.features.print.PrintController;

class PageAction
extends AbstractPrintAction {
    static final String NAME = "page";
    private static final long serialVersionUID = 1L;

    PageAction(PrintController controller) {
        super("PageAction", controller);
    }

    public void actionPerformed(ActionEvent e) {
        if (!this.getPrintController().acquirePrinterJobAndPageFormat(false)) {
            return;
        }
        FitMap fitMap = FitMap.valueOf();
        ButtonGroup fitButtons = new ButtonGroup();
        JRadioButton fitToPage = new JRadioButton();
        MenuBuilder.setLabelAndMnemonic(fitToPage, TextUtils.getRawText("fit_map_to_page"));
        fitToPage.setSelected(fitMap == FitMap.PAGE);
        fitButtons.add(fitToPage);
        JRadioButton fitToWidth = new JRadioButton();
        MenuBuilder.setLabelAndMnemonic(fitToWidth, TextUtils.getRawText("fit_map_to_page_width"));
        fitToWidth.setSelected(fitMap == FitMap.WIDTH);
        fitButtons.add(fitToWidth);
        JRadioButton fitToHeighth = new JRadioButton();
        MenuBuilder.setLabelAndMnemonic(fitToHeighth, TextUtils.getRawText("fit_map_to_page_height"));
        fitToHeighth.setSelected(fitMap == FitMap.HEIGHT);
        fitButtons.add(fitToHeighth);
        JRadioButton userDefaultScale = new JRadioButton();
        MenuBuilder.setLabelAndMnemonic(userDefaultScale, TextUtils.getRawText("user_defined_scale"));
        userDefaultScale.setSelected(fitMap == FitMap.USER_DEFINED);
        fitButtons.add(userDefaultScale);
        JLabel userZoomL = new JLabel(TextUtils.getText("user_zoom"));
        final JTextField userZoom = new JTextField(ResourceController.getResourceController().getProperty("user_zoom"), 3);
        userZoom.setPreferredSize(new Dimension(30, 21));
        if (fitMap == FitMap.USER_DEFINED) {
            userZoom.setEditable(true);
            userZoom.setEnabled(true);
        } else {
            userZoom.setEnabled(false);
            userZoom.setEditable(false);
        }
        JPanel panel = new JPanel();
        GridBagLayout gridbag = new GridBagLayout();
        panel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(), BorderFactory.createEmptyBorder(10, 0, 10, 0)));
        userDefaultScale.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                boolean selected = e.getStateChange() == 1;
                userZoom.setEditable(selected);
                userZoom.setEnabled(selected);
                if (selected) {
                    userZoom.requestFocusInWindow();
                }
            }
        });
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 3;
        c.ipady = 10;
        c.ipadx = 4;
        c.anchor = 21;
        c.insets = new Insets(0, 10, 0, 10);
        gridbag.setConstraints(fitToPage, c);
        panel.add(fitToPage);
        ++c.gridy;
        gridbag.setConstraints(fitToWidth, c);
        panel.add(fitToWidth);
        ++c.gridy;
        gridbag.setConstraints(fitToHeighth, c);
        panel.add(fitToHeighth);
        ++c.gridy;
        gridbag.setConstraints(userDefaultScale, c);
        panel.add(userDefaultScale);
        ++c.gridy;
        c.ipady = 1;
        c.gridx = 0;
        c.gridwidth = 1;
        c.insets = new Insets(0, 0, 0, 0);
        Component b = Box.createRigidArea(new Dimension(25, 1));
        gridbag.setConstraints(b, c);
        panel.add(b);
        c.ipadx = 4;
        c.gridx = 1;
        c.gridwidth = 1;
        gridbag.setConstraints(userZoomL, c);
        panel.add(userZoomL);
        c.gridx = 2;
        c.gridwidth = 1;
        c.ipadx = 10;
        c.insets = new Insets(0, 0, 0, 10);
        gridbag.setConstraints(userZoom, c);
        panel.add(userZoom);
        panel.setLayout(gridbag);
        int result = UITools.showConfirmDialog(null, panel, TextUtils.getText("printing_settings"), 2, -1);
        if (result != 0) {
            return;
        }
        ResourceController.getResourceController().setProperty("user_zoom", userZoom.getText());
        FitMap fitMapDecision = fitToPage.isSelected() ? FitMap.PAGE : (fitToWidth.isSelected() ? FitMap.WIDTH : (fitToHeighth.isSelected() ? FitMap.HEIGHT : FitMap.USER_DEFINED));
        ResourceController.getResourceController().setProperty("fit_map", fitMapDecision.toString());
        PrintController printController = this.getPrintController();
        printController.pageDialog();
    }
}

