/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.nodestyle;

import java.awt.Color;
import java.awt.Font;
import java.util.Collection;
import org.freeplane.core.extension.IExtension;
import org.freeplane.core.io.ReadManager;
import org.freeplane.core.io.WriteManager;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.features.map.MapController;
import org.freeplane.features.map.MapModel;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.mode.CombinedPropertyChain;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.mode.ExclusivePropertyChain;
import org.freeplane.features.mode.IPropertyHandler;
import org.freeplane.features.mode.ModeController;
import org.freeplane.features.nodestyle.NodeSizeModel;
import org.freeplane.features.nodestyle.NodeStyleBuilder;
import org.freeplane.features.nodestyle.NodeStyleModel;
import org.freeplane.features.styles.IStyle;
import org.freeplane.features.styles.LogicalStyleController;
import org.freeplane.features.styles.MapStyleModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NodeStyleController
implements IExtension {
    public static Color standardNodeTextColor = Color.BLACK;
    private final ExclusivePropertyChain<Color, NodeModel> backgroundColorHandlers;
    private final CombinedPropertyChain<Font, NodeModel> fontHandlers;
    private final ModeController modeController;
    private final ExclusivePropertyChain<String, NodeModel> shapeHandlers;
    private final ExclusivePropertyChain<Color, NodeModel> textColorHandlers;
    public static final String NODE_NUMBERING = "NodeNumbering";

    public static NodeStyleController getController() {
        ModeController modeController = Controller.getCurrentModeController();
        return NodeStyleController.getController(modeController);
    }

    public static NodeStyleController getController(ModeController modeController) {
        return modeController.getExtension(NodeStyleController.class);
    }

    public static void install(NodeStyleController styleController) {
        ModeController modeController = Controller.getCurrentModeController();
        modeController.addExtension(NodeStyleController.class, styleController);
    }

    public NodeStyleController(final ModeController modeController) {
        this.modeController = modeController;
        this.fontHandlers = new CombinedPropertyChain(true);
        this.textColorHandlers = new ExclusivePropertyChain();
        this.backgroundColorHandlers = new ExclusivePropertyChain();
        this.shapeHandlers = new ExclusivePropertyChain();
        this.addFontGetter(IPropertyHandler.DEFAULT, new IPropertyHandler<Font, NodeModel>(){

            @Override
            public Font getProperty(NodeModel node, Font currentValue) {
                Font defaultFont = NodeStyleController.getDefaultFont();
                return defaultFont;
            }
        });
        this.addFontGetter(IPropertyHandler.STYLE, new IPropertyHandler<Font, NodeModel>(){

            @Override
            public Font getProperty(NodeModel node, Font currentValue) {
                Font defaultFont = NodeStyleController.this.getStyleFont(currentValue, node.getMap(), LogicalStyleController.getController(modeController).getStyles(node));
                return defaultFont;
            }
        });
        this.addColorGetter(IPropertyHandler.DEFAULT, new IPropertyHandler<Color, NodeModel>(){

            @Override
            public Color getProperty(NodeModel node, Color currentValue) {
                return standardNodeTextColor;
            }
        });
        this.addColorGetter(IPropertyHandler.STYLE, new IPropertyHandler<Color, NodeModel>(){

            @Override
            public Color getProperty(NodeModel node, Color currentValue) {
                return NodeStyleController.this.getStyleTextColor(node.getMap(), LogicalStyleController.getController(modeController).getStyles(node));
            }
        });
        this.addBackgroundColorGetter(IPropertyHandler.STYLE, new IPropertyHandler<Color, NodeModel>(){

            @Override
            public Color getProperty(NodeModel node, Color currentValue) {
                return NodeStyleController.this.getStyleBackgroundColor(node.getMap(), LogicalStyleController.getController(modeController).getStyles(node));
            }
        });
        this.addShapeGetter(IPropertyHandler.STYLE, new IPropertyHandler<String, NodeModel>(){

            @Override
            public String getProperty(NodeModel node, String currentValue) {
                MapModel map = node.getMap();
                LogicalStyleController styleController = LogicalStyleController.getController(modeController);
                Collection<IStyle> style = styleController.getStyles(node);
                String returnedString = NodeStyleController.this.getStyleShape(map, style);
                return returnedString;
            }
        });
        this.addShapeGetter(IPropertyHandler.DEFAULT, new IPropertyHandler<String, NodeModel>(){

            @Override
            public String getProperty(NodeModel node, String currentValue) {
                return this.getShape(node);
            }

            private String getShape(NodeModel node) {
                return "as_parent";
            }
        });
        MapController mapController = modeController.getMapController();
        ReadManager readManager = mapController.getReadManager();
        WriteManager writeManager = mapController.getWriteManager();
        NodeStyleBuilder styleBuilder = new NodeStyleBuilder(this);
        styleBuilder.registerBy(readManager, writeManager);
    }

    public IPropertyHandler<Color, NodeModel> addBackgroundColorGetter(Integer key, IPropertyHandler<Color, NodeModel> getter) {
        return this.backgroundColorHandlers.addGetter(key, getter);
    }

    public IPropertyHandler<Color, NodeModel> addColorGetter(Integer key, IPropertyHandler<Color, NodeModel> getter) {
        return this.textColorHandlers.addGetter(key, getter);
    }

    public IPropertyHandler<Font, NodeModel> addFontGetter(Integer key, IPropertyHandler<Font, NodeModel> getter) {
        return this.fontHandlers.addGetter(key, getter);
    }

    public IPropertyHandler<String, NodeModel> addShapeGetter(Integer key, IPropertyHandler<String, NodeModel> getter) {
        return this.shapeHandlers.addGetter(key, getter);
    }

    public Color getBackgroundColor(NodeModel node) {
        return this.backgroundColorHandlers.getProperty(node);
    }

    public Color getColor(NodeModel node) {
        return this.textColorHandlers.getProperty(node);
    }

    private Color getStyleBackgroundColor(MapModel map, Collection<IStyle> styleKeys) {
        MapStyleModel model = MapStyleModel.getExtension(map);
        for (IStyle styleKey : styleKeys) {
            Color styleColor;
            NodeStyleModel styleModel;
            NodeModel styleNode = model.getStyleNode(styleKey);
            if (styleNode == null || (styleModel = NodeStyleModel.getModel(styleNode)) == null || (styleColor = styleModel.getBackgroundColor()) == null) continue;
            return styleColor;
        }
        return null;
    }

    private int getStyleMaxNodeWidth(MapModel map, Collection<IStyle> styleKeys) {
        MapStyleModel model = MapStyleModel.getExtension(map);
        for (IStyle styleKey : styleKeys) {
            int maxTextWidth;
            NodeSizeModel sizeModel;
            NodeModel styleNode = model.getStyleNode(styleKey);
            if (styleNode == null || (sizeModel = NodeSizeModel.getModel(styleNode)) == null || (maxTextWidth = sizeModel.getMaxNodeWidth()) == -1) continue;
            return maxTextWidth;
        }
        return 600;
    }

    private int getStyleMinWidth(MapModel map, Collection<IStyle> styleKeys) {
        MapStyleModel model = MapStyleModel.getExtension(map);
        for (IStyle styleKey : styleKeys) {
            int minWidth;
            NodeSizeModel sizeModel;
            NodeModel styleNode = model.getStyleNode(styleKey);
            if (styleNode == null || (sizeModel = NodeSizeModel.getModel(styleNode)) == null || (minWidth = sizeModel.getMinNodeWidth()) == -1) continue;
            return minWidth;
        }
        return 1;
    }

    public static Font getDefaultFont() {
        int fontSize = NodeStyleController.getDefaultFontSize();
        int fontStyle = NodeStyleController.getDefaultFontStyle();
        String fontFamily = NodeStyleController.getDefaultFontFamilyName();
        return new Font(fontFamily, fontStyle, fontSize);
    }

    private static String getDefaultFontFamilyName() {
        return ResourceController.getResourceController().getProperty("defaultfont");
    }

    private static int getDefaultFontStyle() {
        return ResourceController.getResourceController().getIntProperty("defaultfontstyle", 0);
    }

    private static int getDefaultFontSize() {
        return ResourceController.getResourceController().getIntProperty("defaultfontsize", 10);
    }

    public Font getDefaultFont(MapModel map, IStyle style) {
        MapStyleModel model = MapStyleModel.getExtension(map);
        NodeModel styleNode = model.getStyleNodeSafe(style);
        return this.getFont(styleNode);
    }

    private Font getStyleFont(Font baseFont, MapModel map, Collection<IStyle> collection) {
        MapStyleModel model = MapStyleModel.getExtension(map);
        Boolean bold = null;
        Boolean italic = null;
        String fontFamilyName = null;
        Integer fontSize = null;
        for (IStyle styleKey : collection) {
            NodeStyleModel styleModel;
            NodeModel styleNode = model.getStyleNode(styleKey);
            if (styleNode == null || (styleModel = NodeStyleModel.getModel(styleNode)) == null) continue;
            if (bold == null) {
                bold = styleModel.isBold();
            }
            if (italic == null) {
                italic = styleModel.isItalic();
            }
            if (fontFamilyName == null) {
                fontFamilyName = styleModel.getFontFamilyName();
            }
            if (fontSize == null) {
                fontSize = styleModel.getFontSize();
            }
            if (bold == null || italic == null || fontFamilyName == null || fontSize == null) continue;
            break;
        }
        return this.createFont(baseFont, fontFamilyName, fontSize, bold, italic);
    }

    private Font createFont(Font baseFont, String family, Integer size, Boolean bold, Boolean italic) {
        if (family == null && size == null && bold == null && italic == null) {
            return baseFont;
        }
        if (family == null) {
            family = baseFont.getFamily();
        }
        if (size == null) {
            size = baseFont.getSize();
        }
        if (bold == null) {
            bold = baseFont.isBold();
        }
        if (italic == null) {
            italic = baseFont.isItalic();
        }
        int style = 0;
        if (bold.booleanValue()) {
            ++style;
        }
        if (italic.booleanValue()) {
            style += 2;
        }
        return new Font(family, style, size);
    }

    private String getStyleShape(MapModel map, Collection<IStyle> style) {
        MapStyleModel model = MapStyleModel.getExtension(map);
        for (IStyle styleKey : style) {
            String shape;
            NodeStyleModel styleModel;
            NodeModel styleNode = model.getStyleNode(styleKey);
            if (styleNode == null || (styleModel = NodeStyleModel.getModel(styleNode)) == null || (shape = styleModel.getShape()) == null) continue;
            return shape;
        }
        return null;
    }

    private Color getStyleTextColor(MapModel map, Collection<IStyle> collection) {
        MapStyleModel model = MapStyleModel.getExtension(map);
        for (IStyle styleKey : collection) {
            Color styleColor;
            NodeStyleModel styleModel;
            NodeModel styleNode = model.getStyleNode(styleKey);
            if (styleNode == null || (styleModel = NodeStyleModel.getModel(styleNode)) == null) continue;
            Color color = styleColor = styleModel == null ? null : styleModel.getColor();
            if (styleColor == null) continue;
            return styleColor;
        }
        return null;
    }

    public Font getFont(NodeModel node) {
        Font font = this.fontHandlers.getProperty(node, null);
        return font;
    }

    public String getFontFamilyName(NodeModel node) {
        Font font = this.getFont(node);
        return font.getFamily();
    }

    public int getFontSize(NodeModel node) {
        Font font = this.getFont(node);
        return font.getSize();
    }

    public String getShape(NodeModel node) {
        String returnedString = this.shapeHandlers.getProperty(node);
        return returnedString;
    }

    public boolean isBold(NodeModel node) {
        return this.getFont(node).isBold();
    }

    public boolean isItalic(NodeModel node) {
        return this.getFont(node).isItalic();
    }

    public IPropertyHandler<Color, NodeModel> removeBackgroundColorGetter(Integer key) {
        return this.backgroundColorHandlers.removeGetter(key);
    }

    public IPropertyHandler<Color, NodeModel> removeColorGetter(Integer key) {
        return this.textColorHandlers.removeGetter(key);
    }

    public IPropertyHandler<Font, NodeModel> removeFontGetter(Integer key) {
        return this.fontHandlers.removeGetter(key);
    }

    public IPropertyHandler<String, NodeModel> removeShapeGetter(Integer key) {
        return this.shapeHandlers.removeGetter(key);
    }

    public Boolean getNodeNumbering(NodeModel node) {
        NodeStyleModel style = node.getExtension(NodeStyleModel.class);
        if (style == null) {
            return false;
        }
        Boolean nodeNumbering = style.getNodeNumbering();
        return nodeNumbering == null ? false : nodeNumbering;
    }

    public String getNodeFormat(NodeModel node) {
        NodeStyleModel style = node.getExtension(NodeStyleModel.class);
        return style == null ? null : style.getNodeFormat();
    }

    public int getMaxWidth(NodeModel node) {
        MapModel map = node.getMap();
        LogicalStyleController styleController = LogicalStyleController.getController(this.modeController);
        Collection<IStyle> style = styleController.getStyles(node);
        int maxTextWidth = this.getStyleMaxNodeWidth(map, style);
        return maxTextWidth;
    }

    public int getMinWidth(NodeModel node) {
        MapModel map = node.getMap();
        LogicalStyleController styleController = LogicalStyleController.getController(this.modeController);
        Collection<IStyle> style = styleController.getStyles(node);
        int minWidth = this.getStyleMinWidth(map, style);
        return minWidth;
    }

    public ModeController getModeController() {
        return this.modeController;
    }
}

