/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.nodestyle;

import java.awt.Color;
import java.io.IOException;
import org.freeplane.core.extension.IExtension;
import org.freeplane.core.io.IAttributeHandler;
import org.freeplane.core.io.IAttributeWriter;
import org.freeplane.core.io.IElementDOMHandler;
import org.freeplane.core.io.IElementWriter;
import org.freeplane.core.io.IExtensionAttributeWriter;
import org.freeplane.core.io.IExtensionElementWriter;
import org.freeplane.core.io.ITreeWriter;
import org.freeplane.core.io.ReadManager;
import org.freeplane.core.io.WriteManager;
import org.freeplane.core.util.ColorUtils;
import org.freeplane.core.util.FreeplaneVersion;
import org.freeplane.features.map.MapWriter;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.nodestyle.NodeSizeModel;
import org.freeplane.features.nodestyle.NodeStyleController;
import org.freeplane.features.nodestyle.NodeStyleModel;
import org.freeplane.n3.nanoxml.XMLElement;

class NodeStyleBuilder
implements IElementDOMHandler,
IExtensionElementWriter,
IExtensionAttributeWriter,
IAttributeWriter,
IElementWriter {
    private final NodeStyleController nsc;

    public NodeStyleBuilder(NodeStyleController nsc) {
        this.nsc = nsc;
    }

    public Object createElement(Object parent, String tag, XMLElement attributes) {
        if (tag.equals("font")) {
            return new FontProperties();
        }
        return null;
    }

    public void endElement(Object parent, String tag, Object userObject, XMLElement dom) {
        if (parent instanceof NodeModel) {
            NodeModel node = (NodeModel)parent;
            if (tag.equals("font")) {
                FontProperties fp = (FontProperties)userObject;
                NodeStyleModel nodeStyleModel = NodeStyleModel.getModel(node);
                if (nodeStyleModel == null) {
                    nodeStyleModel = new NodeStyleModel();
                    node.addExtension(nodeStyleModel);
                }
                nodeStyleModel.setFontFamilyName(fp.fontName);
                nodeStyleModel.setFontSize(fp.fontSize);
                nodeStyleModel.setItalic(fp.isItalic);
                nodeStyleModel.setBold(fp.isBold);
                return;
            }
            return;
        }
    }

    private void registerAttributeHandlers(ReadManager reader) {
        IAttributeHandler colorHandler = new IAttributeHandler(){

            public void setAttribute(Object userObject, String value) {
                if (value.length() == 7) {
                    NodeModel node = (NodeModel)userObject;
                    NodeStyleModel.setColor(node, ColorUtils.stringToColor(value));
                }
            }
        };
        reader.addAttributeHandler("node", "COLOR", colorHandler);
        reader.addAttributeHandler("stylenode", "COLOR", colorHandler);
        IAttributeHandler bgHandler = new IAttributeHandler(){

            public void setAttribute(Object userObject, String value) {
                if (value.length() == 7) {
                    NodeModel node = (NodeModel)userObject;
                    NodeStyleModel.setBackgroundColor(node, ColorUtils.stringToColor(value));
                }
            }
        };
        reader.addAttributeHandler("node", "BACKGROUND_COLOR", bgHandler);
        reader.addAttributeHandler("stylenode", "BACKGROUND_COLOR", bgHandler);
        IAttributeHandler styleHandler = new IAttributeHandler(){

            public void setAttribute(Object userObject, String value) {
                NodeModel node = (NodeModel)userObject;
                NodeStyleModel.setShape(node, value);
            }
        };
        reader.addAttributeHandler("node", "STYLE", styleHandler);
        reader.addAttributeHandler("stylenode", "STYLE", styleHandler);
        reader.addAttributeHandler("font", "SIZE", new IAttributeHandler(){

            public void setAttribute(Object userObject, String value) {
                FontProperties fp = (FontProperties)userObject;
                fp.fontSize = Integer.parseInt(value.toString());
            }
        });
        reader.addAttributeHandler("font", "NAME", new IAttributeHandler(){

            public void setAttribute(Object userObject, String value) {
                FontProperties fp = (FontProperties)userObject;
                fp.fontName = value;
            }
        });
        reader.addAttributeHandler("font", "BOLD", new IAttributeHandler(){

            public void setAttribute(Object userObject, String value) {
                FontProperties fp = (FontProperties)userObject;
                fp.isBold = value.equals("true");
            }
        });
        reader.addAttributeHandler("font", "ITALIC", new IAttributeHandler(){

            public void setAttribute(Object userObject, String value) {
                FontProperties fp = (FontProperties)userObject;
                fp.isItalic = value.equals("true");
            }
        });
        IAttributeHandler nodenumberingHandler = new IAttributeHandler(){

            public void setAttribute(Object userObject, String value) {
                NodeModel node = (NodeModel)userObject;
                NodeStyleModel.setNodeNumbering(node, value.equals("true"));
            }
        };
        reader.addAttributeHandler("node", "NUMBERED", nodenumberingHandler);
        reader.addAttributeHandler("stylenode", "NUMBERED", nodenumberingHandler);
        IAttributeHandler formatHandler = new IAttributeHandler(){

            public void setAttribute(Object userObject, String value) {
                NodeModel node = (NodeModel)userObject;
                NodeStyleModel.setNodeFormat(node, value);
            }
        };
        reader.addAttributeHandler("node", "FORMAT", formatHandler);
        reader.addAttributeHandler("stylenode", "FORMAT", formatHandler);
        if (FreeplaneVersion.getVersion().isOlderThan(new FreeplaneVersion(1, 3, 0))) {
            reader.addAttributeHandler("node", "TEMPLATE", formatHandler);
            reader.addAttributeHandler("stylenode", "TEMPLATE", formatHandler);
        }
        IAttributeHandler nodeMaxNodeWidthHandler = new IAttributeHandler(){

            public void setAttribute(Object userObject, String value) {
                NodeModel node = (NodeModel)userObject;
                NodeSizeModel.setNodeMaxNodeWidth(node, Integer.valueOf(value));
            }
        };
        reader.addAttributeHandler("node", "MAX_WIDTH", nodeMaxNodeWidthHandler);
        reader.addAttributeHandler("stylenode", "MAX_WIDTH", nodeMaxNodeWidthHandler);
        IAttributeHandler nodeMinWidthHandler = new IAttributeHandler(){

            public void setAttribute(Object userObject, String value) {
                NodeModel node = (NodeModel)userObject;
                NodeSizeModel.setNodeMinWidth(node, Integer.valueOf(value));
            }
        };
        reader.addAttributeHandler("node", "MIN_WIDTH", nodeMinWidthHandler);
        reader.addAttributeHandler("stylenode", "MIN_WIDTH", nodeMinWidthHandler);
    }

    public void registerBy(ReadManager reader, WriteManager writer) {
        reader.addElementHandler("font", this);
        this.registerAttributeHandlers(reader);
        writer.addAttributeWriter("node", this);
        writer.addAttributeWriter("stylenode", this);
        writer.addElementWriter("node", this);
        writer.addElementWriter("stylenode", this);
        writer.addExtensionElementWriter(NodeStyleModel.class, this);
        writer.addExtensionAttributeWriter(NodeStyleModel.class, this);
        writer.addExtensionAttributeWriter(NodeSizeModel.class, this);
    }

    public void setAttributes(String tag, Object node, XMLElement attributes) {
    }

    public void writeAttributes(ITreeWriter writer, Object userObject, String tag) {
        boolean forceFormatting = Boolean.TRUE.equals(writer.getHint((Object)MapWriter.WriterHint.FORCE_FORMATTING));
        if (!forceFormatting) {
            return;
        }
        NodeModel node = (NodeModel)userObject;
        this.writeAttributes(writer, node, (NodeStyleModel)null, true);
        this.writeAttributes(writer, node, (NodeSizeModel)null, true);
    }

    public void writeAttributes(ITreeWriter writer, Object userObject, IExtension extension) {
        boolean forceFormatting = Boolean.TRUE.equals(writer.getHint((Object)MapWriter.WriterHint.FORCE_FORMATTING));
        if (forceFormatting) {
            return;
        }
        if (extension instanceof NodeStyleModel) {
            NodeStyleModel style = (NodeStyleModel)extension;
            this.writeAttributes(writer, null, style, false);
            return;
        }
        if (extension instanceof NodeSizeModel) {
            NodeSizeModel size = (NodeSizeModel)extension;
            this.writeAttributes(writer, null, size, false);
            return;
        }
    }

    private void writeAttributes(ITreeWriter writer, NodeModel node, NodeStyleModel style, boolean forceFormatting) {
        String format;
        Boolean numbered;
        String shape;
        Color backgroundColor;
        Color color;
        Color color2 = color = forceFormatting ? this.nsc.getColor(node) : style.getColor();
        if (color != null) {
            writer.addAttribute("COLOR", ColorUtils.colorToString(color));
        }
        Color color3 = backgroundColor = forceFormatting ? this.nsc.getBackgroundColor(node) : style.getBackgroundColor();
        if (backgroundColor != null) {
            writer.addAttribute("BACKGROUND_COLOR", ColorUtils.colorToString(backgroundColor));
        }
        String string = shape = forceFormatting ? this.nsc.getShape(node) : style.getShape();
        if (shape != null) {
            writer.addAttribute("STYLE", shape);
        }
        Boolean bl = numbered = forceFormatting ? this.nsc.getNodeNumbering(node) : style.getNodeNumbering();
        if (numbered != null && numbered.booleanValue()) {
            writer.addAttribute("NUMBERED", numbered.toString());
        }
        String string2 = format = forceFormatting ? this.nsc.getNodeFormat(node) : style.getNodeFormat();
        if (format != null) {
            writer.addAttribute("FORMAT", format);
        }
    }

    private void writeAttributes(ITreeWriter writer, NodeModel node, NodeSizeModel size, boolean forceFormatting) {
        int minTextWidth;
        int maxTextWidth;
        int n = maxTextWidth = forceFormatting ? this.nsc.getMaxWidth(node) : size.getMaxNodeWidth();
        if (maxTextWidth != -1) {
            writer.addAttribute("MAX_WIDTH", Integer.toString(maxTextWidth));
        }
        int n2 = minTextWidth = forceFormatting ? this.nsc.getMinWidth(node) : size.getMinNodeWidth();
        if (minTextWidth != -1) {
            writer.addAttribute("MIN_WIDTH", Integer.toString(minTextWidth));
        }
    }

    public void writeContent(ITreeWriter writer, Object userObject, String tag) throws IOException {
        boolean forceFormatting = Boolean.TRUE.equals(writer.getHint((Object)MapWriter.WriterHint.FORCE_FORMATTING));
        if (!forceFormatting) {
            return;
        }
        NodeModel node = (NodeModel)userObject;
        this.writeContent(writer, node, null, true);
    }

    public void writeContent(ITreeWriter writer, Object userObject, IExtension extension) throws IOException {
        boolean forceFormatting = Boolean.TRUE.equals(writer.getHint((Object)MapWriter.WriterHint.FORCE_FORMATTING));
        if (forceFormatting) {
            return;
        }
        NodeStyleModel style = (NodeStyleModel)extension;
        this.writeContent(writer, null, style, false);
    }

    private void writeContent(ITreeWriter writer, NodeModel node, NodeStyleModel style, boolean forceFormatting) throws IOException {
        if (forceFormatting || style != null) {
            Boolean italic;
            Boolean bold;
            Integer fontSize;
            String fontFamilyName;
            XMLElement fontElement = new XMLElement();
            fontElement.setName("font");
            boolean isRelevant = forceFormatting;
            String string = fontFamilyName = forceFormatting ? this.nsc.getFontFamilyName(node) : style.getFontFamilyName();
            if (fontFamilyName != null) {
                fontElement.setAttribute("NAME", fontFamilyName);
                isRelevant = true;
            }
            Integer n = fontSize = forceFormatting ? Integer.valueOf(this.nsc.getFontSize(node)) : style.getFontSize();
            if (fontSize != null) {
                fontElement.setAttribute("SIZE", Integer.toString(fontSize));
                isRelevant = true;
            }
            Boolean bl = bold = forceFormatting ? Boolean.valueOf(this.nsc.isBold(node)) : style.isBold();
            if (bold != null) {
                fontElement.setAttribute("BOLD", bold != false ? "true" : "false");
                isRelevant = true;
            }
            Boolean bl2 = italic = forceFormatting ? Boolean.valueOf(this.nsc.isItalic(node)) : style.isItalic();
            if (italic != null) {
                fontElement.setAttribute("ITALIC", italic != false ? "true" : "false");
                isRelevant = true;
            }
            if (isRelevant) {
                writer.addElement((Object)style, fontElement);
            }
        }
    }

    static class FontProperties {
        String fontName;
        Integer fontSize;
        Boolean isBold;
        Boolean isItalic;

        FontProperties() {
        }
    }
}

