/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.nodelocation;

import org.freeplane.core.extension.IExtension;
import org.freeplane.core.io.IAttributeHandler;
import org.freeplane.core.io.IExtensionAttributeWriter;
import org.freeplane.core.io.ITreeWriter;
import org.freeplane.core.io.ReadManager;
import org.freeplane.core.io.WriteManager;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.nodelocation.LocationModel;

class LocationBuilder
implements IExtensionAttributeWriter {
    LocationBuilder() {
    }

    private void registerAttributeHandlers(ReadManager reader) {
        reader.addAttributeHandler("node", "VSHIFT", new IAttributeHandler(){

            public void setAttribute(Object userObject, String value) {
                NodeModel node = (NodeModel)userObject;
                LocationModel.createLocationModel(node).setShiftY(Integer.parseInt(value));
            }
        });
        reader.addAttributeHandler("node", "VGAP", new IAttributeHandler(){

            public void setAttribute(Object userObject, String value) {
                NodeModel node = (NodeModel)userObject;
                LocationModel.createLocationModel(node).setVGap(Integer.parseInt(value));
            }
        });
        reader.addAttributeHandler("node", "HGAP", new IAttributeHandler(){

            public void setAttribute(Object userObject, String value) {
                NodeModel node = (NodeModel)userObject;
                LocationModel.createLocationModel(node).setHGap(Integer.parseInt(value));
            }
        });
    }

    void registerBy(ReadManager readManager, WriteManager writeManager) {
        this.registerAttributeHandlers(readManager);
        writeManager.addExtensionAttributeWriter(LocationModel.class, this);
    }

    public void writeAttributes(ITreeWriter writer, Object userObject, IExtension extension) {
        int shiftY;
        LocationModel locationModel = (LocationModel)extension;
        int vGap = locationModel.getVGap();
        if (vGap != 3) {
            writer.addAttribute("VGAP", Integer.toString(vGap));
        }
        int hGap = locationModel.getHGap();
        if (locationModel.getHGap() != 20) {
            writer.addAttribute("HGAP", Integer.toString(hGap));
        }
        if ((shiftY = locationModel.getShiftY()) != 0) {
            writer.addAttribute("VSHIFT", Integer.toString(shiftY));
        }
    }
}

