/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.mode;

import java.util.HashSet;
import java.util.LinkedList;
import org.freeplane.core.util.LogUtils;
import org.freeplane.features.map.INodeSelectionListener;
import org.freeplane.features.map.NodeModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SelectionController {
    private final LinkedList<INodeSelectionListener> nodeSelectionListeners = new LinkedList();

    public void addNodeSelectionListener(INodeSelectionListener listener) {
        this.nodeSelectionListeners.add(listener);
    }

    public LinkedList<INodeSelectionListener> getNodeSelectionListeners() {
        return this.nodeSelectionListeners;
    }

    public void onDeselect(NodeModel node) {
        try {
            HashSet<INodeSelectionListener> copy = new HashSet<INodeSelectionListener>(this.nodeSelectionListeners);
            for (INodeSelectionListener listener : copy) {
                listener.onDeselect(node);
            }
        }
        catch (RuntimeException e) {
            LogUtils.severe("Error in node selection listeners", e);
        }
    }

    public void onSelect(NodeModel node) {
        for (INodeSelectionListener listener : this.nodeSelectionListeners) {
            listener.onSelect(node);
        }
    }

    public void removeNodeSelectionListener(INodeSelectionListener listener) {
        this.nodeSelectionListeners.remove(listener);
    }
}

