/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.mode;

import java.awt.Component;
import java.awt.Container;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.freeplane.core.extension.ExtensionContainer;
import org.freeplane.core.extension.IExtension;
import org.freeplane.core.ui.AFreeplaneAction;
import org.freeplane.core.ui.IMenuContributor;
import org.freeplane.core.ui.IUserInputListenerFactory;
import org.freeplane.core.ui.MenuBuilder;
import org.freeplane.core.undo.IActor;
import org.freeplane.core.undo.IUndoHandler;
import org.freeplane.features.map.IExtensionCopier;
import org.freeplane.features.map.ITooltipProvider;
import org.freeplane.features.map.MapController;
import org.freeplane.features.map.MapModel;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.mode.AController;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.ui.INodeViewLifeCycleListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModeController
extends AController {
    private final ExtensionContainer extensionContainer;
    private final Collection<IExtensionCopier> copiers;
    private boolean isBlocked = false;
    private MapController mapController;
    private final Map<Integer, ITooltipProvider> toolTip = new TreeMap<Integer, ITooltipProvider>();
    private final List<IMenuContributor> menuContributors = new LinkedList<IMenuContributor>();
    private final List<INodeViewLifeCycleListener> nodeViewListeners = new LinkedList<INodeViewLifeCycleListener>();
    private IUserInputListenerFactory userInputListenerFactory;
    private final Controller controller;

    public ModeController(Controller controller) {
        this.controller = controller;
        this.extensionContainer = new ExtensionContainer(new HashMap<Class<? extends IExtension>, IExtension>());
        this.copiers = new LinkedList<IExtensionCopier>();
    }

    @Override
    public void addAction(AFreeplaneAction action) {
        super.addAction(action);
        if (this.mapController != null) {
            this.mapController.addListenerForAction(action);
        }
    }

    public void addExtension(Class<? extends IExtension> clazz, IExtension extension) {
        this.extensionContainer.addExtension(clazz, extension);
    }

    public void registerExtensionCopier(IExtensionCopier copier) {
        this.copiers.add(copier);
    }

    public void unregisterExtensionCopier(IExtensionCopier copier) {
        this.copiers.remove(copier);
    }

    public void copyExtensions(Object key, NodeModel from, NodeModel to) {
        for (IExtensionCopier copier : this.copiers) {
            copier.copy(key, from, to);
        }
    }

    public void undoableCopyExtensions(final Object key, final NodeModel from, final NodeModel to) {
        MapModel map = to.getMap();
        if (map == null) {
            this.copyExtensions(key, from, to);
            return;
        }
        IUndoHandler undoHandler = map.getExtension(IUndoHandler.class);
        if (undoHandler == null) {
            this.copyExtensions(key, from, to);
            return;
        }
        final NodeModel backup = new NodeModel(null);
        this.copyExtensions(key, to, backup);
        IActor actor = new IActor(){

            public void undo() {
                ModeController.this.removeExtensions(key, to);
                ModeController.this.copyExtensions(key, backup, to);
                ModeController.this.getMapController().nodeChanged(to);
            }

            public String getDescription() {
                return "undoableCopyExtensions";
            }

            public void act() {
                ModeController.this.copyExtensions(key, from, to);
                ModeController.this.getMapController().nodeChanged(to);
            }
        };
        this.execute(actor, map);
    }

    void removeExtensions(Object key, NodeModel from, NodeModel which) {
        if (from.equals(which)) {
            for (IExtensionCopier copier : this.copiers) {
                copier.remove(key, from);
            }
            return;
        }
        for (IExtensionCopier copier : this.copiers) {
            copier.remove(key, from, which);
        }
    }

    public void undoableRemoveExtensions(final Object key, final NodeModel from, final NodeModel which) {
        MapModel map = from.getMap();
        if (map == null) {
            this.removeExtensions(key, from, which);
            return;
        }
        IUndoHandler undoHandler = map.getExtension(IUndoHandler.class);
        if (undoHandler == null) {
            this.removeExtensions(key, from, which);
            return;
        }
        final NodeModel backup = new NodeModel(null);
        this.copyExtensions(key, from, backup);
        IActor actor = new IActor(){

            public void undo() {
                ModeController.this.copyExtensions(key, backup, from);
                ModeController.this.getMapController().nodeChanged(from);
            }

            public String getDescription() {
                return "undoableCopyExtensions";
            }

            public void act() {
                ModeController.this.removeExtensions(key, from, which);
                ModeController.this.getMapController().nodeChanged(from);
            }
        };
        this.execute(actor, map);
    }

    public void resolveParentExtensions(Object key, NodeModel to) {
        for (IExtensionCopier copier : this.copiers) {
            copier.resolveParentExtensions(key, to);
        }
    }

    public void undoableResolveParentExtensions(final Object key, final NodeModel to) {
        MapModel map = to.getMap();
        if (map == null) {
            this.resolveParentExtensions(key, to);
            return;
        }
        IUndoHandler undoHandler = map.getExtension(IUndoHandler.class);
        if (undoHandler == null) {
            this.resolveParentExtensions(key, to);
            return;
        }
        final NodeModel backup = new NodeModel(null);
        this.copyExtensions(key, to, backup);
        IActor actor = new IActor(){

            public void undo() {
                ModeController.this.copyExtensions(key, backup, to);
                ModeController.this.getMapController().nodeChanged(to);
            }

            public String getDescription() {
                return "undoableCopyExtensions";
            }

            public void act() {
                ModeController.this.resolveParentExtensions(key, to);
                ModeController.this.getMapController().nodeChanged(to);
            }
        };
        this.execute(actor, map);
    }

    void removeExtensions(Object key, NodeModel from) {
        for (IExtensionCopier copier : this.copiers) {
            copier.remove(key, from, from);
        }
    }

    public void addINodeViewLifeCycleListener(INodeViewLifeCycleListener listener) {
        this.nodeViewListeners.add(listener);
    }

    public void addMenuContributor(IMenuContributor contributor) {
        this.menuContributors.add(contributor);
    }

    public void commit() {
    }

    public boolean isUndoAction() {
        return false;
    }

    public void execute(IActor actor, MapModel map) {
        actor.act();
    }

    @Override
    public AFreeplaneAction getAction(String key) {
        AFreeplaneAction action = super.getAction(key);
        if (action != null) {
            return action;
        }
        return this.getController().getAction(key);
    }

    public Controller getController() {
        return this.controller;
    }

    public <T extends IExtension> T getExtension(Class<T> clazz) {
        return this.extensionContainer.getExtension(clazz);
    }

    public boolean containsExtension(Class<? extends IExtension> clazz) {
        return this.extensionContainer.containsExtension(clazz);
    }

    public void removeExtension(Class<? extends IExtension> clazz) {
        this.extensionContainer.removeExtension(clazz);
    }

    public MapController getMapController() {
        return this.mapController;
    }

    public String getModeName() {
        return null;
    }

    public IUserInputListenerFactory getUserInputListenerFactory() {
        return this.userInputListenerFactory;
    }

    public boolean hasOneVisibleChild(NodeModel parent) {
        int count = 0;
        for (NodeModel child : this.getMapController().childrenUnfolded(parent)) {
            if (child.isVisible()) {
                ++count;
            }
            if (count != 2) continue;
            return false;
        }
        return count == 1;
    }

    public boolean isBlocked() {
        return this.isBlocked;
    }

    public void onViewCreated(Container node) {
        for (INodeViewLifeCycleListener hook : this.nodeViewListeners) {
            hook.onViewCreated(node);
        }
    }

    public void onViewRemoved(Container node) {
        for (INodeViewLifeCycleListener hook : this.nodeViewListeners) {
            hook.onViewRemoved(node);
        }
    }

    @Override
    public AFreeplaneAction removeAction(String key) {
        AFreeplaneAction action = super.removeAction(key);
        if (this.mapController != null) {
            this.mapController.removeListenerForAction(action);
        }
        return action;
    }

    public void removeINodeViewLifeCycleListener(INodeViewLifeCycleListener listener) {
        this.nodeViewListeners.remove(listener);
    }

    public void rollback() {
    }

    public void setBlocked(boolean isBlocked) {
        this.isBlocked = isBlocked;
    }

    public void setMapController(MapController mapController) {
        this.mapController = mapController;
        this.addExtension(MapController.class, mapController);
    }

    public void setUserInputListenerFactory(IUserInputListenerFactory userInputListenerFactory) {
        this.userInputListenerFactory = userInputListenerFactory;
    }

    public void setVisible(boolean visible) {
        NodeModel node = this.getController().getSelection().getSelected();
        if (visible) {
            this.mapController.onSelect(node);
        } else if (node != null) {
            this.mapController.onDeselect(node);
        }
    }

    public void shutdown() {
    }

    public void startTransaction() {
    }

    public void forceNewTransaction() {
    }

    public void startup() {
    }

    public void updateMenus(String menuStructure, Set<String> plugins) {
        IUserInputListenerFactory userInputListenerFactory = this.getUserInputListenerFactory();
        userInputListenerFactory.updateMenus(menuStructure, plugins);
        MenuBuilder menuBuilder = userInputListenerFactory.getMenuBuilder();
        Iterator<IMenuContributor> iterator = this.menuContributors.iterator();
        while (iterator.hasNext()) {
            iterator.next().updateMenus(this, menuBuilder);
        }
    }

    public boolean canEdit() {
        return false;
    }

    public String createToolTip(NodeModel node, Component view) {
        String style = "<style type='text/css'> body { font-size: 10pt; }</style>";
        StringBuilder text = new StringBuilder("<html><head><style type='text/css'> body { font-size: 10pt; }</style></head><body>");
        boolean tooltipSet = false;
        for (ITooltipProvider provider : this.toolTip.values()) {
            String value = provider.getTooltip(this, node, view);
            if (value == null) continue;
            value = value.replace("<html>", "<div>");
            value = value.replaceAll("\\s*</?(body|head)>", "");
            value = value.replace("<td>", "<td style='background-color: white'>");
            value = value.replace("</html>", "</div>");
            if (tooltipSet) {
                text.append("<br>");
            }
            text.append(value);
            tooltipSet = true;
        }
        if (tooltipSet) {
            text.append("</body></html>");
            return text.toString();
        }
        return null;
    }

    public void addToolTipProvider(Integer key, ITooltipProvider tooltip) {
        if (tooltip == null) {
            if (this.toolTip.containsKey(key)) {
                this.toolTip.remove(key);
            }
        } else {
            this.toolTip.put(key, tooltip);
        }
    }
}

