/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.mode;

import java.awt.event.ActionEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.IOExceptionWithCause;
import org.freeplane.core.extension.ExtensionContainer;
import org.freeplane.core.extension.IExtension;
import org.freeplane.core.resources.OptionPanelController;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.core.resources.components.IValidator;
import org.freeplane.core.util.LogUtils;
import org.freeplane.features.map.IMapSelection;
import org.freeplane.features.map.MapModel;
import org.freeplane.features.mode.AController;
import org.freeplane.features.mode.CenterSelectedNodeAction;
import org.freeplane.features.mode.IControllerExecuteExtension;
import org.freeplane.features.mode.ModeController;
import org.freeplane.features.mode.MoveToRootAction;
import org.freeplane.features.ui.IMapViewManager;
import org.freeplane.features.ui.ViewController;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Controller
extends AController {
    private final ExtensionContainer extensionContainer;
    private ModeController modeController;
    private ModeController modeController4build;
    private final Map<String, ModeController> modeControllers = new LinkedHashMap<String, ModeController>();
    private ViewController viewController;
    private final ResourceController resourceController;
    private final List<IValidator> optionValidators = new ArrayList<IValidator>();
    private final OptionPanelController optionPanelController;
    private IMapViewManager mapViewManager;
    private static ThreadLocal<Controller> threadController = new ThreadLocal();
    private static Controller currentController = null;

    public Controller(ResourceController resourceController) {
        if (currentController == null) {
            currentController = this;
        }
        this.resourceController = resourceController;
        this.optionPanelController = new OptionPanelController();
        this.extensionContainer = new ExtensionContainer(new HashMap<Class<? extends IExtension>, IExtension>());
        this.addAction(new MoveToRootAction());
        this.addAction(new CenterSelectedNodeAction());
    }

    public void addExtension(Class<? extends IExtension> clazz, IExtension extension) {
        this.extensionContainer.addExtension(clazz, extension);
    }

    public void addModeController(ModeController modeController) {
        this.modeControllers.put(modeController.getModeName(), modeController);
    }

    public void close(boolean withoutSave) {
        this.getMapViewManager().close(withoutSave);
    }

    public <T extends IExtension> T getExtension(Class<T> clazz) {
        return this.extensionContainer.getExtension(clazz);
    }

    public MapModel getMap() {
        return this.getMapViewManager().getModel();
    }

    public IMapViewManager getMapViewManager() {
        return this.mapViewManager;
    }

    public void setMapViewManager(IMapViewManager mapViewManager) {
        this.mapViewManager = mapViewManager;
    }

    public ModeController getModeController() {
        return this.modeController4build != null ? this.modeController4build : this.modeController;
    }

    public ModeController getModeController(String modeName) {
        return this.modeControllers.get(modeName);
    }

    public Set<String> getModes() {
        return this.modeControllers.keySet();
    }

    public IMapSelection getSelection() {
        return this.getMapViewManager().getMapSelection();
    }

    public ViewController getViewController() {
        return this.viewController;
    }

    public void quit() {
        if (this.shutdown()) {
            System.exit(0);
        }
    }

    public void quit(ActionEvent actionEvent) {
        this.getActions().get("QuitAction").actionPerformed(actionEvent);
    }

    public void selectMode(ModeController newModeController) {
        this.modeController4build = null;
        ModeController oldModeController = this.modeController;
        if (oldModeController == newModeController) {
            return;
        }
        if (oldModeController != null) {
            oldModeController.shutdown();
        }
        LogUtils.info("requesting mode: " + newModeController.getModeName());
        this.modeController = newModeController;
        this.viewController.selectMode(oldModeController, newModeController);
        this.getMapViewManager().changeToMode(newModeController.getModeName());
        newModeController.startup();
    }

    public void selectMode(String modeName) {
        ModeController newModeController = this.modeControllers.get(modeName);
        if (newModeController == null) {
            return;
        }
        if (this.modeController == newModeController) {
            return;
        }
        this.selectMode(newModeController);
    }

    public void setViewController(ViewController viewController) {
        this.viewController = viewController;
    }

    public boolean shutdown() {
        this.getViewController().saveProperties();
        ResourceController.getResourceController().saveProperties();
        if (!this.getViewController().quit()) {
            return false;
        }
        this.extensionContainer.getExtensions().clear();
        return true;
    }

    public static void exec(String string) throws IOException {
        Controller.exec(string, false);
    }

    public static void exec(String string, boolean waitFor) throws IOException {
        IControllerExecuteExtension ext = Controller.getCurrentController().getExtension(IControllerExecuteExtension.class);
        if (ext == null) {
            ext = Controller.getCurrentController().getDefaultExecuter();
        }
        ext.exec(string, waitFor);
    }

    public static void exec(String[] command) throws IOException {
        Controller.exec(command, false);
    }

    public static void exec(String[] command, boolean waitFor) throws IOException {
        IControllerExecuteExtension ext = Controller.getCurrentController().getExtension(IControllerExecuteExtension.class);
        if (ext == null) {
            ext = Controller.getCurrentController().getDefaultExecuter();
        }
        ext.exec(command, waitFor);
    }

    private IControllerExecuteExtension getDefaultExecuter() {
        return new IControllerExecuteExtension(){

            public void exec(String[] command, boolean waitFor) throws IOException {
                LogUtils.info("execute " + Arrays.toString(command));
                Process proc = Runtime.getRuntime().exec(command);
                this.waiting(waitFor, proc);
            }

            public void exec(String string, boolean waitFor) throws IOException {
                LogUtils.info("execute " + string);
                Process proc = Runtime.getRuntime().exec(string);
                this.waiting(waitFor, proc);
            }

            private void waiting(boolean waitFor, Process proc) throws IOExceptionWithCause {
                if (waitFor) {
                    try {
                        proc.waitFor();
                    }
                    catch (InterruptedException e) {
                        throw new IOExceptionWithCause((Throwable)e);
                    }
                }
            }
        };
    }

    public static Controller getCurrentController() {
        Controller controller = threadController.get();
        return controller != null ? controller : currentController;
    }

    public static void setCurrentController(Controller controller) {
        currentController = controller;
    }

    public static ModeController getCurrentModeController() {
        return Controller.getCurrentController().getModeController();
    }

    public void selectModeForBuild(ModeController modeController4build) {
        this.modeController4build = modeController4build;
    }

    public ResourceController getResourceController() {
        return this.resourceController;
    }

    public void addOptionValidator(IValidator validator) {
        this.optionValidators.add(validator);
    }

    public List<IValidator> getOptionValidators() {
        return this.optionValidators;
    }

    public OptionPanelController getOptionPanelController() {
        return this.optionPanelController;
    }
}

