/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.mode;

import java.util.HashMap;
import java.util.Map;
import org.freeplane.core.resources.IFreeplanePropertyListener;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.core.ui.AFreeplaneAction;
import org.freeplane.core.ui.SelectableAction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AController {
    private final Map<String, AFreeplaneAction> actions = new HashMap<String, AFreeplaneAction>();

    public void addAction(AFreeplaneAction value) {
        String key = value.getKey();
        AFreeplaneAction old = this.getActions().put(key, value);
        if (old != null && !old.equals(value)) {
            this.getActions().put(key, old);
            throw new RuntimeException("action " + key + " already registered");
        }
        if (AFreeplaneAction.checkSelectionOnPropertyChange(value)) {
            ActionSelectorOnPropertyChange listener = new ActionSelectorOnPropertyChange(value);
            ResourceController.getResourceController().addPropertyChangeListener(listener);
        }
    }

    public AFreeplaneAction getAction(String key) {
        return this.getActions().get(key);
    }

    protected Map<String, AFreeplaneAction> getActions() {
        return this.actions;
    }

    public AFreeplaneAction removeAction(String key) {
        AFreeplaneAction action = this.getActions().remove(key);
        if (AFreeplaneAction.checkSelectionOnPropertyChange(action)) {
            ResourceController.getResourceController().removePropertyChangeListener(ActionSelectorOnPropertyChange.class, action);
        }
        return action;
    }

    public static interface IActionOnChange {
        public AFreeplaneAction getAction();
    }

    private static class ActionSelectorOnPropertyChange
    implements IFreeplanePropertyListener,
    IActionOnChange {
        final String propertyName;
        final AFreeplaneAction action;

        public ActionSelectorOnPropertyChange(AFreeplaneAction action) {
            this.action = action;
            this.propertyName = action.getClass().getAnnotation(SelectableAction.class).checkOnPropertyChange();
        }

        public AFreeplaneAction getAction() {
            return this.action;
        }

        public void propertyChanged(String propertyName, String newValue, String oldValue) {
            if (this.propertyName.equals(propertyName)) {
                this.action.setSelected();
            }
        }
    }
}

