/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.map;

import java.io.IOException;
import org.freeplane.core.io.IAttributeWriter;
import org.freeplane.core.io.IElementWriter;
import org.freeplane.core.io.ITreeWriter;
import org.freeplane.core.io.xml.TreeXmlWriter;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.features.map.EncryptionModel;
import org.freeplane.features.map.MapController;
import org.freeplane.features.map.MapWriter;
import org.freeplane.features.map.NodeModel;
import org.freeplane.n3.nanoxml.XMLElement;

class NodeWriter
implements IElementWriter,
IAttributeWriter {
    private boolean mayWriteChildren;
    private final MapController mapController;
    private final boolean shouldWriteChildren;
    private final boolean writeFolded;
    private final boolean writeInvisible;
    private XMLElement xmlNode;
    private final String nodeTag;

    public NodeWriter(MapController mapController, String nodeTag, boolean writeChildren, boolean writeInvisible) {
        this.mapController = mapController;
        this.shouldWriteChildren = writeChildren;
        this.mayWriteChildren = true;
        this.writeInvisible = writeInvisible;
        this.nodeTag = nodeTag;
        String saveFolding = ResourceController.getResourceController().getProperty("save_folding");
        this.writeFolded = saveFolding.equals("always_save_folding") || saveFolding.equals("save_folding_if_map_is_changed");
    }

    private void saveChildren(ITreeWriter writer, NodeModel node) throws IOException {
        for (NodeModel child : this.mapController.childrenUnfolded(node)) {
            if (this.writeInvisible || child.isVisible()) {
                writer.addElement((Object)child, this.nodeTag);
                continue;
            }
            this.saveChildren(writer, child);
        }
    }

    public void writeAttributes(ITreeWriter writer, Object content, String tag) {
        if (tag.equals(this.nodeTag)) {
            NodeModel node = (NodeModel)content;
            this.writeAttributesGenerateContent(writer, node);
            return;
        }
    }

    private void writeAttributesGenerateContent(ITreeWriter writer, NodeModel node) {
        boolean saveID;
        NodeModel parentNode;
        String enctyptedContent;
        this.xmlNode = new XMLElement();
        EncryptionModel encryptionModel = EncryptionModel.getModel(node);
        this.mayWriteChildren = true;
        Object mode = writer.getHint((Object)MapWriter.Hint.MODE);
        if (!(encryptionModel == null || encryptionModel.isAccessible() && MapWriter.Mode.EXPORT.equals(mode) || (enctyptedContent = encryptionModel.getEncryptedContent(this.mapController)) == null)) {
            writer.addAttribute("ENCRYPTED_CONTENT", enctyptedContent);
            this.mayWriteChildren = false;
        }
        if (this.mayWriteChildren && (this.writeFolded || !writer.getHint((Object)MapWriter.Hint.MODE).equals((Object)MapWriter.Mode.FILE))) {
            if (this.mapController.isFolded(node)) {
                writer.addAttribute("FOLDED", "true");
            } else if (node.isRoot() && !MapWriter.Mode.STYLE.equals(mode)) {
                writer.addAttribute("FOLDED", "false");
            }
        }
        if ((parentNode = node.getParentNode()) != null && parentNode.isRoot()) {
            writer.addAttribute("POSITION", node.isLeft() ? "left" : "right");
        }
        boolean bl = saveID = !mode.equals((Object)MapWriter.Mode.STYLE);
        if (saveID) {
            String id = node.createID();
            writer.addAttribute("ID", id);
        }
        if (!mode.equals((Object)MapWriter.Mode.STYLE) && node.getHistoryInformation() != null && ResourceController.getResourceController().getBooleanProperty("save_modification_times")) {
            writer.addAttribute("CREATED", TreeXmlWriter.dateToString(node.getHistoryInformation().getCreatedAt()));
            writer.addAttribute("MODIFIED", TreeXmlWriter.dateToString(node.getHistoryInformation().getLastModifiedAt()));
        }
        writer.addExtensionAttributes(node, node.getExtensions().values());
    }

    public void writeContent(ITreeWriter writer, Object content, String tag) throws IOException {
        NodeModel node = (NodeModel)content;
        writer.addExtensionNodes(node, node.getExtensions().values());
        for (int i = 0; i < this.xmlNode.getChildrenCount(); ++i) {
            writer.addElement(null, this.xmlNode.getChildAtIndex(i));
        }
        if (this.mayWriteChildren && this.shouldWriteChildren && this.mapController.childrenUnfolded(node).size() > 0) {
            this.saveChildren(writer, node);
        }
    }

    String getNodeTag() {
        return this.nodeTag;
    }
}

