/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.map;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import org.freeplane.core.extension.ExtensionContainer;
import org.freeplane.core.extension.IExtension;
import org.freeplane.core.extension.SmallExtensionMap;
import org.freeplane.core.util.HtmlUtils;
import org.freeplane.core.util.XmlUtils;
import org.freeplane.features.filter.Filter;
import org.freeplane.features.filter.FilterInfo;
import org.freeplane.features.icon.MindIcon;
import org.freeplane.features.map.AlwaysUnfoldedNode;
import org.freeplane.features.map.EncryptionModel;
import org.freeplane.features.map.HistoryInformationModel;
import org.freeplane.features.map.INodeView;
import org.freeplane.features.map.MapModel;
import org.freeplane.features.map.NodeChangeEvent;
import org.freeplane.features.map.NodeIconSetModel;
import org.freeplane.features.ui.INodeViewVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NodeModel
implements MutableTreeNode {
    private static final boolean ALLOWSCHILDREN = true;
    public static final int LEFT_POSITION = -1;
    public static final String NODE_TEXT = "node_text";
    public static final String NOTE_TEXT = "note_text";
    public static final int RIGHT_POSITION = 1;
    public static final int UNKNOWN_POSITION = 0;
    public static final Object UNKNOWN_PROPERTY = new Object();
    public static final String NODE_ICON = "icon";
    public static final Object HYPERLINK_CHANGED = "hyperlink_changed";
    private final List<NodeModel> children = new ArrayList<NodeModel>();
    private final ExtensionContainer extensionContainer;
    private final FilterInfo filterInfo = new FilterInfo();
    private boolean folded;
    private HistoryInformationModel historyInformation = null;
    private final NodeIconSetModel icons;
    private String id;
    private MapModel map = null;
    private NodeModel parent;
    private int position = 0;
    private NodeModel preferredChild;
    private Object userObject = null;
    private Collection<INodeView> views = null;
    private String xmlText = null;

    public Object getUserObject() {
        return this.userObject;
    }

    public NodeModel(MapModel map) {
        this("", map);
    }

    public NodeModel(Object userObject, MapModel map) {
        this.extensionContainer = new ExtensionContainer(new SmallExtensionMap());
        this.init(userObject);
        this.map = map;
        this.icons = new NodeIconSetModel();
    }

    protected void init(Object userObject) {
        this.setUserObject(userObject);
        this.setHistoryInformation(new HistoryInformationModel());
    }

    public void acceptViewVisitor(INodeViewVisitor visitor) {
        if (this.views == null) {
            return;
        }
        for (INodeView view : this.views) {
            visitor.visit(view);
        }
    }

    public void addExtension(IExtension extension) {
        this.extensionContainer.addExtension(extension);
    }

    public IExtension putExtension(IExtension extension) {
        return this.extensionContainer.putExtension(extension);
    }

    public void addIcon(MindIcon icon) {
        this.icons.addIcon(icon);
        if (this.map != null) {
            this.map.getIconRegistry().addIcon(icon);
        }
    }

    public void addIcon(MindIcon icon, int position) {
        this.icons.addIcon(icon, position);
        this.getMap().getIconRegistry().addIcon(icon);
    }

    public void addViewer(INodeView viewer) {
        this.getViewers().add(viewer);
    }

    public boolean areViewsEmpty() {
        return this.views == null || this.views.isEmpty();
    }

    protected List<NodeModel> getChildrenInternal() {
        return this.children;
    }

    public Enumeration<NodeModel> children() {
        final Iterator<NodeModel> i = this.getChildrenInternal().iterator();
        return new Enumeration<NodeModel>(){

            @Override
            public boolean hasMoreElements() {
                return i.hasNext();
            }

            @Override
            public NodeModel nextElement() {
                return (NodeModel)i.next();
            }
        };
    }

    public boolean containsExtension(Class<? extends IExtension> clazz) {
        return this.extensionContainer.containsExtension(clazz);
    }

    public String createID() {
        if (this.id == null) {
            this.id = this.getMap().registryNode(this);
        }
        return this.id;
    }

    public void fireNodeChanged(NodeChangeEvent nodeChangeEvent) {
        if (this.views == null) {
            return;
        }
        Iterator<INodeView> iterator = this.views.iterator();
        while (iterator.hasNext()) {
            iterator.next().nodeChanged(nodeChangeEvent);
        }
    }

    private void fireNodeInserted(NodeModel child, int index) {
        if (this.views == null) {
            return;
        }
        Iterator<INodeView> iterator = this.views.iterator();
        while (iterator.hasNext()) {
            iterator.next().onNodeInserted(this, child, index);
        }
    }

    private void fireNodeRemoved(NodeModel child, int index) {
        if (this.views == null) {
            return;
        }
        Iterator<INodeView> iterator = this.views.iterator();
        while (iterator.hasNext()) {
            iterator.next().onNodeDeleted(this, child, index);
        }
    }

    @Override
    public boolean getAllowsChildren() {
        return true;
    }

    @Override
    public TreeNode getChildAt(int childIndex) {
        return this.getChildrenInternal().get(childIndex);
    }

    @Override
    public int getChildCount() {
        if (this.getChildrenInternal() == null) {
            return 0;
        }
        EncryptionModel encryptionModel = EncryptionModel.getModel(this);
        return encryptionModel == null || encryptionModel.isAccessible() ? this.getChildrenInternal().size() : 0;
    }

    public int getChildPosition(NodeModel childNode) {
        int position = 0;
        ListIterator<NodeModel> i = this.getChildrenInternal().listIterator();
        while (i.hasNext()) {
            if (i.next() == childNode) {
                return position;
            }
            ++position;
        }
        return -1;
    }

    public List<NodeModel> getChildren() {
        List<Object> childrenList = this.getChildrenInternal() != null ? this.getChildrenInternal() : Collections.emptyList();
        return Collections.unmodifiableList(childrenList);
    }

    public <T extends IExtension> T getExtension(Class<T> clazz) {
        return this.extensionContainer.getExtension(clazz);
    }

    public Map<Class<? extends IExtension>, IExtension> getExtensions() {
        return this.extensionContainer.getExtensions();
    }

    public FilterInfo getFilterInfo() {
        return this.filterInfo;
    }

    public HistoryInformationModel getHistoryInformation() {
        return this.historyInformation;
    }

    public MindIcon getIcon(int position) {
        return this.icons.getIcon(position);
    }

    public List<MindIcon> getIcons() {
        return this.icons.getIcons();
    }

    public String getID() {
        return this.id;
    }

    @Override
    public int getIndex(TreeNode node) {
        return this.getChildrenInternal().indexOf(node);
    }

    public MapModel getMap() {
        return this.map;
    }

    public int getNodeLevel(boolean countHidden) {
        int level = 0;
        for (NodeModel parent = this.getParentNode(); parent != null; parent = parent.getParentNode()) {
            if (!countHidden && !parent.isVisible()) continue;
            ++level;
        }
        return level;
    }

    @Override
    public TreeNode getParent() {
        return this.parent;
    }

    public NodeModel getParentNode() {
        return this.parent;
    }

    public NodeModel[] getPathToRoot() {
        int i = this.getNodeLevel(true);
        NodeModel[] path = new NodeModel[i + 1];
        NodeModel node = this;
        while (i >= 0) {
            path[i--] = node;
            node = node.getParentNode();
        }
        return path;
    }

    public String getText() {
        String string = "";
        if (this.userObject != null) {
            string = this.userObject.toString();
        }
        return string;
    }

    public Collection<INodeView> getViewers() {
        if (this.views == null) {
            this.views = new LinkedList<INodeView>();
        }
        return this.views;
    }

    public final String getXmlText() {
        return this.xmlText;
    }

    public boolean hasChildren() {
        return this.getChildCount() != 0;
    }

    public boolean hasID() {
        return this.id != null;
    }

    @Override
    public void insert(MutableTreeNode child, int index) {
        if (!this.isAccessible()) {
            throw new IllegalArgumentException("Trying to insert nodes into a ciphered node.");
        }
        NodeModel childNode = (NodeModel)child;
        if (index < 0) {
            index = this.getChildCount();
            this.getChildrenInternal().add(index, (NodeModel)child);
        } else {
            this.getChildrenInternal().add(index, (NodeModel)child);
            this.preferredChild = childNode;
        }
        child.setParent(this);
        this.fireNodeInserted(childNode, this.getIndex(child));
    }

    private boolean isAccessible() {
        EncryptionModel encryptionModel = EncryptionModel.getModel(this);
        return encryptionModel == null || encryptionModel.isAccessible();
    }

    public boolean isDescendantOf(NodeModel node) {
        if (this.parent == null) {
            return false;
        }
        if (node == this.parent) {
            return true;
        }
        return this.parent.isDescendantOf(node);
    }

    public boolean isFolded() {
        return this.folded;
    }

    @Override
    public boolean isLeaf() {
        return this.getChildCount() == 0;
    }

    public boolean isLeft() {
        if (this.position == 0 && this.getParentNode() != null) {
            this.setLeft(this.getParentNode().isLeft());
        }
        return this.position == -1;
    }

    public boolean isNewChildLeft() {
        if (!this.isRoot()) {
            return this.isLeft();
        }
        int rightChildrenCount = 0;
        for (int i = 0; i < this.getChildCount(); ++i) {
            if (!((NodeModel)this.getChildAt(i)).isLeft()) {
                ++rightChildrenCount;
            }
            if (rightChildrenCount <= this.getChildCount() / 2) continue;
            return true;
        }
        return false;
    }

    public boolean isRoot() {
        return this.getMap().getRootNode() == this;
    }

    public boolean isVisible() {
        Filter filter = this.getMap().getFilter();
        return filter == null || filter.isVisible(this);
    }

    @Override
    public void remove(int index) {
        MutableTreeNode node = this.getChildrenInternal().get(index);
        this.remove(node);
    }

    @Override
    public void remove(MutableTreeNode node) {
        int index;
        if (node == this.preferredChild) {
            index = this.getChildrenInternal().indexOf(node);
            this.preferredChild = this.getChildrenInternal().size() > index + 1 ? this.getChildrenInternal().get(index + 1) : (index > 0 ? this.getChildrenInternal().get(index - 1) : null);
        }
        index = this.getIndex(node);
        node.setParent(null);
        this.getChildrenInternal().remove(node);
        this.fireNodeRemoved((NodeModel)node, index);
    }

    public <T extends IExtension> T removeExtension(Class<T> clazz) {
        return this.extensionContainer.removeExtension(clazz);
    }

    public boolean removeExtension(IExtension extension) {
        return this.extensionContainer.removeExtension(extension);
    }

    @Override
    public void removeFromParent() {
        this.parent.remove(this);
    }

    public int removeIcon() {
        return this.icons.removeIcon();
    }

    public int removeIcon(int position) {
        return this.icons.removeIcon(position);
    }

    public void removeViewer(INodeView viewer) {
        this.getViewers().remove(viewer);
    }

    public void setFolded(boolean folded) {
        if (this.folded == folded) {
            return;
        }
        EncryptionModel encryptionModel = EncryptionModel.getModel(this);
        if (encryptionModel != null && !encryptionModel.isAccessible() && !folded) {
            folded = true;
        } else if (AlwaysUnfoldedNode.isConnectorNode(this)) {
            folded = false;
        }
        if (this.folded == folded) {
            return;
        }
        this.folded = folded;
        this.fireNodeChanged(new NodeChangeEvent(this, (Object)NodeChangeType.FOLDING, !folded, folded));
    }

    public void setHistoryInformation(HistoryInformationModel historyInformation) {
        this.historyInformation = historyInformation;
    }

    public void setID(String value) {
        this.id = value;
        this.getMap().registryID(value, this);
    }

    public void setLeft(boolean isLeft) {
        int n = this.position = isLeft ? -1 : 1;
        if (!this.isRoot()) {
            for (int i = 0; i < this.getChildCount(); ++i) {
                NodeModel child = (NodeModel)this.getChildAt(i);
                if (child.position == this.position) continue;
                child.setLeft(isLeft);
            }
        }
    }

    public void setMap(MapModel map) {
        this.map = map;
        for (NodeModel child : this.getChildrenInternal()) {
            child.setMap(map);
        }
    }

    @Override
    public void setParent(MutableTreeNode newParent) {
        this.parent = (NodeModel)newParent;
    }

    public void setParent(NodeModel newParent) {
        this.parent = newParent;
    }

    public final void setText(String text) {
        this.userObject = XmlUtils.makeValidXml(text);
        this.xmlText = HtmlUtils.toXhtml(text);
        if (this.xmlText != null && !this.xmlText.startsWith("<")) {
            this.userObject = " " + text;
            this.xmlText = null;
        }
    }

    @Override
    public final void setUserObject(Object data) {
        if (data instanceof String) {
            this.setText(data.toString());
            return;
        }
        this.userObject = data;
        this.xmlText = null;
    }

    public final void setXmlText(String pXmlText) {
        this.xmlText = XmlUtils.makeValidXml(pXmlText);
        this.userObject = HtmlUtils.toHtml(this.xmlText);
    }

    public String toString() {
        return HtmlUtils.htmlToPlain(this.getText());
    }

    public int depth() {
        NodeModel parentNode = this.getParentNode();
        if (parentNode == null) {
            return 0;
        }
        return parentNode.depth() + 1;
    }

    public void insert(NodeModel newNodeModel) {
        this.insert(newNodeModel, this.getChildCount());
    }

    public NodeModel getVisibleAncestorOrSelf() {
        NodeModel node = this;
        while (!node.isVisible()) {
            node = node.getParentNode();
        }
        return node;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum NodeChangeType {
        FOLDING,
        REFRESH;

    }
}

