/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.map;

import javax.swing.ComboBoxEditor;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import org.freeplane.core.resources.NamedObject;
import org.freeplane.core.ui.FixedBasicComboBoxEditor;
import org.freeplane.core.util.TextUtils;
import org.freeplane.features.filter.condition.ASelectableCondition;
import org.freeplane.features.filter.condition.IElementaryConditionController;
import org.freeplane.features.map.LeafCondition;
import org.freeplane.features.map.NodeLevelCompareCondition;
import org.freeplane.features.map.NumberComboBoxEditor;
import org.freeplane.features.map.PeriodicLevelCondition;
import org.freeplane.features.map.RootCondition;
import org.freeplane.n3.nanoxml.XMLElement;

class NodeLevelConditionController
implements IElementaryConditionController {
    static final String FILTER_LEVEL = "filter_node_level";
    static final String FILTER_ROOT = "filter_root";
    static final String FILTER_LEAF = "filter_leaf";
    static final String FILTER_PERIODIC_LEVEL = "filter_periodic_level";
    private final ComboBoxEditor levelEditor = new NumberComboBoxEditor();
    private final ComboBoxModel values = new DefaultComboBoxModel();
    private final ComboBoxModel periodicValues = new DefaultComboBoxModel<PeriodicLevelCondition>(PeriodicLevelCondition.createConditions(7));

    NodeLevelConditionController() {
    }

    public boolean canEditValues(Object selectedItem, NamedObject simpleCond) {
        return !simpleCond.objectEquals(FILTER_PERIODIC_LEVEL);
    }

    public boolean canHandle(Object selectedItem) {
        if (!(selectedItem instanceof NamedObject)) {
            return false;
        }
        NamedObject namedObject = (NamedObject)selectedItem;
        return namedObject.objectEquals(FILTER_LEVEL);
    }

    public boolean canSelectValues(Object selectedItem, NamedObject simpleCondition) {
        if (simpleCondition.objectEquals("filter_is_equal_to")) {
            return true;
        }
        if (simpleCondition.objectEquals("filter_is_not_equal_to")) {
            return true;
        }
        if (simpleCondition.objectEquals(">")) {
            return true;
        }
        if (simpleCondition.objectEquals(">=")) {
            return true;
        }
        if (simpleCondition.objectEquals("<")) {
            return true;
        }
        if (simpleCondition.objectEquals("<=")) {
            return true;
        }
        return simpleCondition.objectEquals(FILTER_PERIODIC_LEVEL);
    }

    public ASelectableCondition createCondition(Object selectedItem, NamedObject simpleCond, Object value, boolean matchCase, boolean matchApproximately) {
        if (value instanceof PeriodicLevelCondition) {
            return (ASelectableCondition)value;
        }
        return this.createASelectableCondition(simpleCond, (String)value, matchCase, matchApproximately);
    }

    protected ASelectableCondition createASelectableCondition(NamedObject simpleCondition, String value, boolean matchCase, boolean matchApproximately) {
        if (simpleCondition.objectEquals("filter_is_equal_to")) {
            return new NodeLevelCompareCondition(value, matchCase, 0, true);
        }
        if (simpleCondition.objectEquals("filter_is_not_equal_to")) {
            return new NodeLevelCompareCondition(value, matchCase, 0, false);
        }
        if (simpleCondition.objectEquals(">")) {
            return new NodeLevelCompareCondition(value, matchCase, 1, true);
        }
        if (simpleCondition.objectEquals(">=")) {
            return new NodeLevelCompareCondition(value, matchCase, -1, false);
        }
        if (simpleCondition.objectEquals("<")) {
            return new NodeLevelCompareCondition(value, matchCase, -1, true);
        }
        if (simpleCondition.objectEquals("<=")) {
            return new NodeLevelCompareCondition(value, matchCase, 1, false);
        }
        if (simpleCondition.objectEquals(FILTER_ROOT)) {
            return new RootCondition();
        }
        if (simpleCondition.objectEquals(FILTER_LEAF)) {
            return new LeafCondition();
        }
        return null;
    }

    public ComboBoxModel getConditionsForProperty(Object selectedItem) {
        return new DefaultComboBoxModel<NamedObject>(new NamedObject[]{TextUtils.createTranslatedString("filter_is_equal_to"), TextUtils.createTranslatedString("filter_is_not_equal_to"), NamedObject.literal(">"), NamedObject.literal(">="), NamedObject.literal("<="), NamedObject.literal("<"), TextUtils.createTranslatedString(FILTER_ROOT), TextUtils.createTranslatedString(FILTER_LEAF), TextUtils.createTranslatedString(FILTER_PERIODIC_LEVEL)});
    }

    public ListModel getFilteredProperties() {
        DefaultListModel<NamedObject> list = new DefaultListModel<NamedObject>();
        list.addElement(TextUtils.createTranslatedString(FILTER_LEVEL));
        return list;
    }

    public ComboBoxEditor getValueEditor(Object selectedProperty, NamedObject selectedCondition) {
        if (selectedCondition.objectEquals(FILTER_PERIODIC_LEVEL)) {
            return new FixedBasicComboBoxEditor();
        }
        return this.levelEditor;
    }

    public ComboBoxModel getValuesForProperty(Object property, NamedObject simpleCond) {
        if (simpleCond.objectEquals(FILTER_PERIODIC_LEVEL)) {
            return this.periodicValues;
        }
        return this.values;
    }

    public boolean isCaseDependent(Object selectedItem, NamedObject simpleCond) {
        return false;
    }

    public boolean supportsApproximateMatching(Object selectedItem, NamedObject simpleCond) {
        return false;
    }

    public ASelectableCondition loadCondition(XMLElement element) {
        if (element.getName().equalsIgnoreCase("node_level_condition")) {
            return NodeLevelCompareCondition.load(element);
        }
        if (element.getName().equalsIgnoreCase("node_root_condition")) {
            return RootCondition.load(element);
        }
        if (element.getName().equalsIgnoreCase("node_leaf_condition")) {
            return LeafCondition.load(element);
        }
        if (element.getName().equalsIgnoreCase("node_periodic_level_condition")) {
            return PeriodicLevelCondition.load(element);
        }
        return null;
    }

    public ListCellRenderer getValueRenderer(Object selectedProperty, NamedObject selectedCondition) {
        return null;
    }
}

