/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.map;

import java.io.IOException;
import java.io.Writer;
import java.util.Arrays;
import org.freeplane.core.extension.IExtension;
import org.freeplane.core.io.IAttributeWriter;
import org.freeplane.core.io.IElementWriter;
import org.freeplane.core.io.ITreeWriter;
import org.freeplane.core.io.WriteManager;
import org.freeplane.core.io.xml.TreeXmlWriter;
import org.freeplane.features.map.MapController;
import org.freeplane.features.map.MapModel;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.map.NodeWriter;
import org.freeplane.n3.nanoxml.XMLElement;

public class MapWriter
implements IElementWriter,
IAttributeWriter {
    private static final String USAGE_COMMENT = "<!--To view this file, download free mind mapping software Freeplane from http://freeplane.sourceforge.net -->" + System.getProperty("line.separator");
    private NodeWriter currentNodeWriter;
    private final MapController mapController;
    private boolean saveInvisible;
    private final WriteManager writeManager;

    public MapWriter(MapController mapController) {
        this.mapController = mapController;
        this.writeManager = mapController.getWriteManager();
    }

    public boolean isSaveInvisible() {
        return this.saveInvisible;
    }

    public void setSaveInvisible(boolean saveInvisible) {
        this.saveInvisible = saveInvisible;
    }

    public void writeAttributes(ITreeWriter writer, Object userObject, String tag) {
        MapModel map = (MapModel)userObject;
        writer.addAttribute("version", "freeplane 1.3.0");
        writer.addExtensionAttributes(map, Arrays.asList(map.getExtensions().values().toArray(new IExtension[0])));
    }

    public void writeContent(ITreeWriter writer, Object node, String tag) throws IOException {
        writer.addElementContent(USAGE_COMMENT);
        MapModel map = (MapModel)node;
        writer.addExtensionNodes(map, Arrays.asList(map.getExtensions().values().toArray(new IExtension[0])));
        NodeModel rootNode = map.getRootNode();
        this.writeNode(writer, rootNode, this.saveInvisible, true);
    }

    public void writeMapAsXml(MapModel map, Writer fileout, Mode mode, boolean saveInvisible, boolean forceFormat) throws IOException {
        TreeXmlWriter xmlWriter = new TreeXmlWriter(this.writeManager, fileout);
        xmlWriter.setHint((Object)Hint.MODE, (Object)mode);
        if (forceFormat) {
            xmlWriter.setHint((Object)WriterHint.FORCE_FORMATTING);
        }
        XMLElement xmlMap = new XMLElement("map");
        this.setSaveInvisible(saveInvisible);
        xmlWriter.addElement((Object)map, xmlMap);
        xmlWriter.flush();
        fileout.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeNode(ITreeWriter xmlWriter, NodeModel node, boolean writeInvisible, boolean writeChildren) throws IOException {
        NodeWriter oldNodeWriter = this.currentNodeWriter;
        Object mode = xmlWriter.getHint((Object)Hint.MODE);
        String nodeTag = Mode.STYLE.equals(mode) ? "stylenode" : "node";
        if (oldNodeWriter != null) {
            this.writeManager.removeElementWriter(oldNodeWriter.getNodeTag(), oldNodeWriter);
            this.writeManager.removeAttributeWriter(oldNodeWriter.getNodeTag(), oldNodeWriter);
        }
        this.currentNodeWriter = new NodeWriter(this.mapController, nodeTag, writeChildren, writeInvisible);
        try {
            this.writeManager.addElementWriter(nodeTag, this.currentNodeWriter);
            this.writeManager.addAttributeWriter(nodeTag, this.currentNodeWriter);
            xmlWriter.addElement((Object)node, nodeTag);
        }
        finally {
            this.writeManager.removeElementWriter(nodeTag, this.currentNodeWriter);
            this.writeManager.removeAttributeWriter(nodeTag, this.currentNodeWriter);
            if (oldNodeWriter != null) {
                this.writeManager.addElementWriter(oldNodeWriter.getNodeTag(), oldNodeWriter);
                this.writeManager.addAttributeWriter(oldNodeWriter.getNodeTag(), oldNodeWriter);
            }
            this.currentNodeWriter = oldNodeWriter;
        }
    }

    public void writeNodeAsXml(Writer writer, NodeModel node, Mode mode, boolean writeInvisible, boolean writeChildren, boolean forceFormat) throws IOException {
        TreeXmlWriter xmlWriter = new TreeXmlWriter(this.writeManager, writer);
        xmlWriter.setHint((Object)Hint.MODE, (Object)mode);
        if (forceFormat) {
            xmlWriter.setHint((Object)WriterHint.FORCE_FORMATTING);
        }
        this.writeNode(xmlWriter, node, writeInvisible, writeChildren);
        xmlWriter.flush();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Mode {
        CLIPBOARD,
        FILE,
        EXPORT,
        STYLE;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Hint {
        MODE;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum WriterHint {
        FORCE_FORMATTING;

    }
}

