/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.map;

import org.freeplane.features.map.MapController;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.mode.Controller;

public class MapNavigationUtils {
    public static NodeModel findNext(MapController.Direction direction, NodeModel current, NodeModel end) {
        NodeModel parentNode;
        if (current.getChildCount() != 0) {
            NodeModel next = (NodeModel)current.getChildAt(0);
            if (MapNavigationUtils.atEnd(next, end)) {
                return null;
            }
            return next;
        }
        do {
            NodeModel next;
            int childCount;
            if ((parentNode = current.getParentNode()) == null) {
                return current;
            }
            int index = parentNode.getIndex(current) + 1;
            if (index >= (childCount = parentNode.getChildCount())) continue;
            if (direction == MapController.Direction.FORWARD_N_FOLD) {
                Controller.getCurrentModeController().getMapController().setFolded(current, true);
            }
            if (MapNavigationUtils.atEnd(next = (NodeModel)parentNode.getChildAt(index), end)) {
                return null;
            }
            return next;
        } while (!MapNavigationUtils.atEnd(current = parentNode, end));
        return null;
    }

    private static boolean atEnd(NodeModel current, NodeModel end) {
        return end != null && current.equals(end);
    }

    public static NodeModel findPrevious(MapController.Direction direction, NodeModel current, NodeModel end) {
        NodeModel parentNode = current.getParentNode();
        if (parentNode != null) {
            int index;
            if (direction == MapController.Direction.BACK_N_FOLD) {
                Controller.getCurrentModeController().getMapController().setFolded(current, true);
            }
            if ((index = parentNode.getIndex(current) - 1) < 0) {
                if (direction == MapController.Direction.BACK_N_FOLD) {
                    Controller.getCurrentModeController().getMapController().setFolded(parentNode, true);
                }
                if (MapNavigationUtils.atEnd(parentNode, end)) {
                    return null;
                }
                return parentNode;
            }
            current = (NodeModel)parentNode.getChildAt(index);
            if (MapNavigationUtils.atEnd(current, end)) {
                return null;
            }
        }
        while (true) {
            if (current.getChildCount() == 0) {
                if (MapNavigationUtils.atEnd(current, end)) {
                    return null;
                }
                return current;
            }
            current = (NodeModel)current.getChildAt(current.getChildCount() - 1);
        }
    }
}

