/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.map;

import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.MouseWheelEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JPopupMenu;
import org.freeplane.core.extension.IExtension;
import org.freeplane.core.ui.AFreeplaneAction;
import org.freeplane.core.ui.AMultipleNodeAction;
import org.freeplane.core.ui.IMouseWheelEventHandler;
import org.freeplane.core.ui.IUserInputListenerFactory;
import org.freeplane.features.map.AlwaysUnfoldedNode;
import org.freeplane.features.map.EncryptionModel;
import org.freeplane.features.map.HideChildSubtree;
import org.freeplane.features.map.MapController;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.mode.ModeController;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FoldingController
implements IMouseWheelEventHandler,
IExtension {
    protected static Insets nullInsets = new Insets(0, 0, 0, 0);

    public static void install(FoldingController foldingController) {
        Controller.getCurrentModeController().addExtension(FoldingController.class, foldingController);
    }

    public FoldingController() {
        ModeController modeController = Controller.getCurrentModeController();
        if (!modeController.getController().getViewController().isHeadless()) {
            IUserInputListenerFactory userInputListenerFactory = modeController.getUserInputListenerFactory();
            userInputListenerFactory.addMouseWheelEventHandler(this);
            for (AFreeplaneAction aFreeplaneAction : this.getAnnotatedActions()) {
                modeController.addAction(aFreeplaneAction);
            }
        }
    }

    private List<AMultipleNodeAction> getAnnotatedActions() {
        ArrayList<AMultipleNodeAction> result = new ArrayList<AMultipleNodeAction>();
        result.add(new UnfoldAllAction());
        result.add(new FoldAllAction());
        result.add(new UnfoldOneLevelAction());
        result.add(new FoldOneLevelAction());
        return result;
    }

    protected void foldAll(NodeModel node) {
        MapController modeController = Controller.getCurrentModeController().getMapController();
        this.setFolded(node, true);
        for (NodeModel child : modeController.childrenUnfolded(node)) {
            this.foldAll(child);
        }
    }

    public void foldLastBranches(NodeModel node) {
        MapController mapController = Controller.getCurrentModeController().getMapController();
        boolean nodeHasChildWhichIsLeave = false;
        for (NodeModel child : mapController.childrenUnfolded(node)) {
            if (child.getChildCount() != 0) continue;
            nodeHasChildWhichIsLeave = true;
        }
        this.setFolded(node, nodeHasChildWhichIsLeave);
        for (NodeModel child : mapController.childrenUnfolded(node)) {
            this.foldLastBranches(child);
        }
    }

    protected void foldOneStage(NodeModel node) {
        this.foldStageN(node, this.getMaxDepth(node) - 1);
    }

    public void foldStageN(NodeModel node, int stage) {
        int k = this.depth(node);
        if (k < stage) {
            this.setFolded(node, false);
            MapController mapController = Controller.getCurrentModeController().getMapController();
            for (NodeModel child : mapController.childrenUnfolded(node)) {
                this.foldStageN(child, stage);
            }
        } else {
            this.foldAll(node);
        }
    }

    protected int getMaxDepth(NodeModel node) {
        MapController mapController = Controller.getCurrentModeController().getMapController();
        if (mapController.isFolded(node) || !mapController.hasChildren(node)) {
            return this.depth(node);
        }
        int k = 0;
        for (NodeModel child : mapController.childrenUnfolded(node)) {
            int l = this.getMaxDepth(child);
            if (l <= k) continue;
            k = l;
        }
        return k;
    }

    public int getMinDepth(NodeModel node) {
        EncryptionModel encryptionModel = EncryptionModel.getModel(node);
        if (encryptionModel != null && !encryptionModel.isAccessible()) {
            return Integer.MAX_VALUE;
        }
        MapController mapController = Controller.getCurrentModeController().getMapController();
        if (node.containsExtension(HideChildSubtree.class)) {
            return this.depth(node) - 1;
        }
        if (mapController.isFolded(node)) {
            return this.depth(node);
        }
        if (!mapController.hasChildren(node) || AlwaysUnfoldedNode.isConnectorNode(node)) {
            return Integer.MAX_VALUE;
        }
        int k = Integer.MAX_VALUE;
        for (NodeModel child : mapController.childrenUnfolded(node)) {
            int l = this.getMinDepth(child);
            if (l >= k) continue;
            k = l;
        }
        return k;
    }

    @Override
    public boolean handleMouseWheelEvent(MouseWheelEvent e) {
        if ((e.getModifiers() & 8) != 0) {
            Controller controller = Controller.getCurrentController();
            NodeModel rootNode = controller.getMap().getRootNode();
            if (e.getWheelRotation() > 0) {
                this.unfoldOneStage(rootNode);
            } else {
                ModeController modeController = controller.getModeController();
                modeController.getMapController().select(controller.getMap().getRootNode());
                this.foldOneStage(rootNode);
            }
            return true;
        }
        return false;
    }

    private void setFolded(NodeModel node, boolean state) {
        MapController mapController = Controller.getCurrentModeController().getMapController();
        if (!node.isRoot()) {
            mapController.setFolded(node, state);
        }
    }

    public void unfoldAll(NodeModel node) {
        this.setFolded(node, false);
        MapController mapController = Controller.getCurrentModeController().getMapController();
        for (NodeModel child : mapController.childrenUnfolded(node)) {
            this.unfoldAll(child);
        }
    }

    protected void unfoldOneStage(NodeModel node) {
        int minDepth = this.getMinDepth(node);
        if (minDepth < Integer.MAX_VALUE) {
            ++minDepth;
        }
        this.unfoldStageN(node, minDepth);
    }

    public void unfoldStageN(NodeModel node, int stage) {
        int k = this.depth(node);
        if (k < stage) {
            this.setFolded(node, false);
            MapController mapController = Controller.getCurrentModeController().getMapController();
            for (NodeModel child : mapController.childrenUnfolded(node)) {
                this.unfoldStageN(child, stage);
            }
        } else {
            this.foldAll(node);
        }
    }

    private int depth(NodeModel node) {
        if (node.isRoot()) {
            return 0;
        }
        int parentDepth = this.depth(node.getParentNode());
        if (!node.isVisible() || AlwaysUnfoldedNode.isConnectorNode(node)) {
            return parentDepth;
        }
        return parentDepth + 1;
    }

    public JPopupMenu createFoldingPopupMenu(NodeModel node) {
        return new FoldingPopupMenu(node);
    }

    private class FoldingPopupMenu
    extends JPopupMenu {
        private final NodeModel node;

        FoldingPopupMenu(NodeModel node) {
            this.node = node;
            this.addAction(new UnfoldOneLevelPopupAction());
            this.addAction(new FoldOneLevelPopupAction());
            this.addAction(new UnfoldAllPopupAction());
            this.addAction(new FoldAllPopupAction());
        }

        private JButton addAction(Action a) {
            JButton menuItem = new JButton(a);
            menuItem.setToolTipText(menuItem.getText());
            menuItem.setText(null);
            this.add(menuItem);
            menuItem.setMargin(nullInsets);
            return menuItem;
        }

        private class UnfoldOneLevelPopupAction
        extends UnfoldOneLevelAction {
            private UnfoldOneLevelPopupAction() {
            }

            public void actionPerformed(ActionEvent e) {
                this.actionPerformed(e, FoldingPopupMenu.this.node);
            }
        }

        private class UnfoldAllPopupAction
        extends UnfoldAllAction {
            private UnfoldAllPopupAction() {
            }

            public void actionPerformed(ActionEvent e) {
                this.actionPerformed(e, FoldingPopupMenu.this.node);
            }
        }

        private class FoldOneLevelPopupAction
        extends FoldOneLevelAction {
            private FoldOneLevelPopupAction() {
            }

            public void actionPerformed(ActionEvent e) {
                this.actionPerformed(e, FoldingPopupMenu.this.node);
            }
        }

        private class FoldAllPopupAction
        extends FoldAllAction {
            private FoldAllPopupAction() {
            }

            public void actionPerformed(ActionEvent e) {
                this.actionPerformed(e, FoldingPopupMenu.this.node);
            }
        }
    }

    private class UnfoldOneLevelAction
    extends AMultipleNodeAction {
        public UnfoldOneLevelAction() {
            super("UnfoldOneLevelAction");
        }

        public void actionPerformed(ActionEvent e, NodeModel node) {
            FoldingController.this.unfoldOneStage(node);
        }
    }

    private class UnfoldAllAction
    extends AMultipleNodeAction {
        public UnfoldAllAction() {
            super("UnfoldAllAction");
        }

        public void actionPerformed(ActionEvent e, NodeModel node) {
            FoldingController.this.unfoldAll(node);
        }
    }

    private class FoldOneLevelAction
    extends AMultipleNodeAction {
        public FoldOneLevelAction() {
            super("FoldOneLevelAction");
        }

        public void actionPerformed(ActionEvent e, NodeModel node) {
            FoldingController.this.foldOneStage(node);
        }
    }

    private class FoldAllAction
    extends AMultipleNodeAction {
        public FoldAllAction() {
            super("FoldAllAction");
        }

        public void actionPerformed(ActionEvent e, NodeModel node) {
            FoldingController.this.foldAll(node);
        }
    }
}

