/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.map;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ListIterator;
import org.freeplane.core.extension.IExtension;
import org.freeplane.core.util.LogUtils;
import org.freeplane.features.map.IEncrypter;
import org.freeplane.features.map.MapController;
import org.freeplane.features.map.MapWriter;
import org.freeplane.features.map.NodeModel;

public class EncryptionModel
implements IExtension {
    private String encryptedContent;
    private boolean isAccessible = true;
    private boolean isDecrypted = true;
    private IEncrypter mEncrypter;
    private final NodeModel node;

    public static EncryptionModel getModel(NodeModel node) {
        return node.getExtension(EncryptionModel.class);
    }

    public EncryptionModel(NodeModel node) {
        this.node = node;
        this.encryptedContent = null;
        this.setAccessible(true);
        this.isDecrypted = true;
    }

    public EncryptionModel(NodeModel node, String encryptedContent) {
        this.node = node;
        this.encryptedContent = encryptedContent;
        this.setAccessible(false);
        this.isDecrypted = false;
    }

    public boolean checkPassword(IEncrypter encrypter) {
        String decryptedNode = this.decryptXml(this.encryptedContent, encrypter);
        if (decryptedNode == null || !decryptedNode.equals("") && !decryptedNode.startsWith("<node ")) {
            LogUtils.warn("Wrong password supplied (stored!=given).");
            return false;
        }
        this.setEncrypter(encrypter);
        return true;
    }

    public boolean decrypt(MapController mapController, IEncrypter encrypter) {
        if (!this.checkPassword(encrypter)) {
            return false;
        }
        this.setAccessible(true);
        if (!this.isDecrypted) {
            try {
                String childXml = this.decryptXml(this.encryptedContent, encrypter);
                String[] childs = childXml.split("<nodeseparator>");
                for (int i = 0; i < childs.length; ++i) {
                    String string = childs[i];
                    if (string.length() == 0) continue;
                    this.pasteXML(string, this.node, mapController);
                }
                this.isDecrypted = true;
            }
            catch (Exception e) {
                LogUtils.severe(e);
                this.setAccessible(false);
                return true;
            }
        }
        return true;
    }

    private String decryptXml(String encryptedString, IEncrypter encrypter) {
        String decrypted = encrypter.decrypt(encryptedString);
        return decrypted;
    }

    private String encryptXml(StringBuffer childXml) {
        try {
            String encrypted = this.mEncrypter.encrypt(childXml.toString());
            return encrypted;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Can't encrypt the node.", e);
        }
    }

    private void generateEncryptedContent(MapController mapController) throws IOException {
        StringWriter sWriter = new StringWriter();
        ListIterator<NodeModel> i = this.node.getChildren().listIterator();
        while (i.hasNext()) {
            NodeModel child = (NodeModel)i.next();
            mapController.getMapWriter().writeNodeAsXml(sWriter, child, MapWriter.Mode.FILE, true, true, false);
            if (!i.hasNext()) continue;
            sWriter.write("<nodeseparator>");
        }
        StringBuffer childXml = sWriter.getBuffer();
        this.encryptedContent = this.encryptXml(childXml);
    }

    public String getEncryptedContent(MapController mapController) {
        if (this.isDecrypted) {
            try {
                this.generateEncryptedContent(mapController);
            }
            catch (Exception e) {
                LogUtils.severe(e);
            }
        }
        return this.encryptedContent;
    }

    public boolean isAccessible() {
        return this.isAccessible;
    }

    private void pasteXML(String pasted, NodeModel target, MapController mapController) {
        try {
            NodeModel node = mapController.getMapReader().createNodeTreeFromXml(target.getMap(), (Reader)new StringReader(pasted), MapWriter.Mode.FILE);
            mapController.insertNodeIntoWithoutUndo(node, target, target.getChildCount());
        }
        catch (Exception ee) {
            LogUtils.severe(ee);
        }
    }

    public void setAccessible(boolean isAccessible) {
        this.isAccessible = isAccessible;
    }

    public void setEncrypter(IEncrypter encrypter) {
        this.mEncrypter = encrypter;
    }
}

