/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.link;

import java.util.List;
import org.freeplane.features.link.EvaluationDependencies;
import org.freeplane.features.map.IMapChangeListener;
import org.freeplane.features.map.INodeChangeListener;
import org.freeplane.features.map.MapChangeEvent;
import org.freeplane.features.map.NodeChangeEvent;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.mode.ModeController;
import org.freeplane.features.text.IContentTransformer;

public class NodeUpdateChangeListener
implements INodeChangeListener,
IMapChangeListener {
    public void nodeChanged(NodeChangeEvent event) {
        Object property = event.getProperty();
        if ("node_text".equals(property)) {
            this.nodeChangedImpl(false, event.getNode());
        }
    }

    public void onNodeDeleted(NodeModel parent, NodeModel child, int index) {
        this.nodeChangedImpl(true, parent);
    }

    public void onNodeInserted(NodeModel parent, NodeModel child, int newIndex) {
        this.nodeChangedImpl(true, parent);
    }

    public void onNodeMoved(NodeModel oldParent, int oldIndex, NodeModel newParent, NodeModel child, int newIndex) {
        this.nodeChangedImpl(true, oldParent, newParent);
    }

    public void onPreNodeMoved(NodeModel oldParent, int oldIndex, NodeModel newParent, NodeModel child, int newIndex) {
    }

    public void onPreNodeDelete(NodeModel oldParent, NodeModel selectedNode, int index) {
    }

    public void mapChanged(MapChangeEvent event) {
    }

    private void nodeChangedImpl(boolean includeChanged, NodeModel ... nodes) {
        ModeController modeController = Controller.getCurrentModeController();
        List<NodeModel> dependencies = EvaluationDependencies.manageChangeAndReturnDependencies(includeChanged, nodes);
        for (NodeModel dependentNode : dependencies) {
            modeController.getMapController().delayedNodeRefresh(dependentNode, IContentTransformer.class, null, null);
        }
    }
}

