/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.link;

import java.net.URI;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import org.freeplane.core.extension.IExtension;
import org.freeplane.features.link.HyperTextLinkModel;
import org.freeplane.features.link.LinkModel;
import org.freeplane.features.link.MapLinks;
import org.freeplane.features.link.NodeLinkModel;
import org.freeplane.features.map.MapModel;
import org.freeplane.features.map.NodeModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NodeLinks
implements IExtension {
    private URI hyperlink;
    private Boolean formatNodeAsHyperlink;
    private final LinkedList<LinkModel> links = new LinkedList();

    public static NodeLinks createLinkExtension(NodeModel node) {
        NodeLinks linkExtension = NodeLinks.getLinkExtension(node);
        if (linkExtension != null) {
            return linkExtension;
        }
        linkExtension = new NodeLinks();
        node.addExtension(linkExtension);
        return linkExtension;
    }

    public static URI getLink(NodeModel node) {
        NodeLinks links = NodeLinks.getModel(node);
        return links != null ? links.getHyperLink() : null;
    }

    public static Boolean formatNodeAsHyperlink(NodeModel node) {
        NodeLinks links = NodeLinks.getModel(node);
        return links != null ? links.formatNodeAsHyperlink() : null;
    }

    public static String getLinkAsString(NodeModel selectedNode) {
        URI link = NodeLinks.getValidLink(selectedNode);
        return link != null ? link.toString() : null;
    }

    public static NodeLinks getLinkExtension(NodeModel node) {
        return node.getExtension(NodeLinks.class);
    }

    public static Collection<LinkModel> getLinks(NodeModel node) {
        NodeLinks links = NodeLinks.getLinkExtension(node);
        return links != null ? links.getLinks() : Collections.emptyList();
    }

    public static NodeLinks getModel(NodeModel node) {
        NodeLinks links = node.getExtension(NodeLinks.class);
        return links;
    }

    public void addArrowlink(NodeLinkModel newLink) {
        this.links.add(newLink);
        MapModel map = newLink.getSource().getMap();
        this.addLinkToMap(map, newLink);
    }

    private void addLinkToMap(MapModel map, LinkModel newLink) {
        MapLinks mapLinks = MapLinks.getLinks(map);
        if (mapLinks == null) {
            mapLinks = new MapLinks();
            map.addExtension(mapLinks);
        }
        mapLinks.add(newLink);
    }

    public URI getHyperLink() {
        return this.hyperlink;
    }

    public Collection<LinkModel> getLinks() {
        return Collections.unmodifiableCollection(this.links);
    }

    public void removeArrowlink(NodeLinkModel link) {
        NodeModel node = link.getSource();
        Iterator iterator = NodeLinks.getLinkExtension((NodeModel)node).links.iterator();
        while (iterator.hasNext()) {
            LinkModel i = (LinkModel)iterator.next();
            if (i != link) continue;
            iterator.remove();
        }
        MapModel map = link.getSource().getMap();
        this.removeLinkFromMap(map, link);
    }

    private void removeLinkFromMap(MapModel map, LinkModel link) {
        MapLinks mapLinks = MapLinks.getLinks(map);
        mapLinks.remove(link);
    }

    public String removeLocalHyperLink(NodeModel node) {
        Iterator iterator = this.links.iterator();
        while (iterator.hasNext()) {
            LinkModel link = (LinkModel)iterator.next();
            if (!(link instanceof HyperTextLinkModel)) continue;
            iterator.remove();
            this.removeLinkFromMap(node.getMap(), link);
            return link.getTargetID();
        }
        return null;
    }

    public void setHyperLink(URI hyperlink) {
        this.hyperlink = hyperlink;
    }

    public void setLocalHyperlink(NodeModel node, String targetID) {
        this.removeLocalHyperLink(node);
        if (targetID != null) {
            HyperTextLinkModel link = new HyperTextLinkModel(node, targetID);
            this.links.add(link);
            this.addLinkToMap(node.getMap(), link);
        }
    }

    public static URI getValidLink(NodeModel model) {
        URI link = NodeLinks.getLink(model);
        if (link == null) {
            return null;
        }
        String linkString = link.toString();
        if (linkString.startsWith("#")) {
            String id = linkString.substring(1);
            if (model.getMap().getNodeForID(id) == null) {
                return null;
            }
        }
        return link;
    }

    public Boolean formatNodeAsHyperlink() {
        return this.formatNodeAsHyperlink;
    }

    public void setFormatNodeAsHyperlink(Boolean formatNodeAsHyperlink) {
        this.formatNodeAsHyperlink = formatNodeAsHyperlink;
    }
}

