/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.link;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.freeplane.core.extension.IExtension;
import org.freeplane.features.link.LinkModel;
import org.freeplane.features.map.MapModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapLinks
implements IExtension {
    private final HashMap<String, Set<LinkModel>> links = new HashMap();

    public boolean add(LinkModel link) {
        String targetID = link.getTargetID();
        Set<LinkModel> set = this.links.get(targetID);
        if (set == null) {
            set = new HashSet<LinkModel>();
            set.add(link);
            this.links.put(targetID, set);
            return true;
        }
        if (set.contains(link)) {
            return false;
        }
        set.add(link);
        return true;
    }

    public boolean containsTarget(String targetID) {
        return this.links.containsKey(targetID);
    }

    public Set<LinkModel> get(String targetID) {
        if (targetID == null) {
            return null;
        }
        Set<LinkModel> set = this.links.get(targetID);
        return set == null ? null : Collections.unmodifiableSet(set);
    }

    public boolean remove(LinkModel link) {
        String targetID = link.getTargetID();
        Set<LinkModel> set = this.links.get(targetID);
        if (set == null) {
            return false;
        }
        if (set.remove(link)) {
            if (set.isEmpty()) {
                this.links.remove(targetID);
            }
            return true;
        }
        return false;
    }

    public void set(String targetID, Set<LinkModel> set) {
        this.links.put(targetID, set);
    }

    public static MapLinks getLinks(MapModel map) {
        return map.getExtension(MapLinks.class);
    }
}

