/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.link;

import java.net.URI;
import javax.swing.Icon;
import org.freeplane.core.ui.components.ObjectAndIcon;
import org.freeplane.features.link.NodeUpdateChangeListener;
import org.freeplane.features.map.MapModel;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.mode.ModeController;
import org.freeplane.features.text.AbstractContentTransformer;
import org.freeplane.features.text.TextController;
import org.freeplane.features.ui.FrameController;

public class LinkTransformer
extends AbstractContentTransformer {
    private ModeController modeController;

    public LinkTransformer(ModeController modeController, int priority) {
        super(priority);
        this.modeController = modeController;
    }

    public void registerListeners(ModeController modeController) {
        NodeUpdateChangeListener listener = new NodeUpdateChangeListener();
        modeController.getMapController().addNodeChangeListener(listener);
        modeController.getMapController().addMapChangeListener(listener);
    }

    public Object transformContent(TextController textController, Object content, NodeModel node, Object transformedExtension) {
        if ("NO_FORMAT".equals(textController.getNodeFormat(node))) {
            return content;
        }
        MapModel map = node.getMap();
        return this.transformContent(content, map);
    }

    public Object transformContent(Object content, MapModel map) {
        if (!(content instanceof URI)) {
            return content;
        }
        String string = content.toString();
        if (!string.startsWith("#")) {
            return content;
        }
        String nodeID = string.substring(1);
        NodeModel target = map.getNodeForID(nodeID);
        if (target != null) {
            String shortText = TextController.getController(this.modeController).getShortText(target);
            Icon icon = FrameController.localLinkIcon;
            return new ObjectAndIcon(shortText, icon);
        }
        return content;
    }
}

