/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.link;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.freeplane.core.extension.IExtension;
import org.freeplane.features.map.MapModel;
import org.freeplane.features.map.NodeModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class EvaluationDependencies
implements IExtension {
    private HashMap<NodeModel, HashSet<NodeModel>> onNodeDependencies = new HashMap();

    EvaluationDependencies() {
    }

    private static EvaluationDependencies getEvaluationDependencies(MapModel map) {
        EvaluationDependencies dependencies = map.getExtension(EvaluationDependencies.class);
        if (dependencies == null) {
            dependencies = new EvaluationDependencies();
            map.addExtension(dependencies);
        }
        return dependencies;
    }

    public static List<NodeModel> manageChangeAndReturnDependencies(boolean includeChanged, NodeModel ... nodes) {
        ArrayList<NodeModel> dependencies = new ArrayList<NodeModel>();
        for (int i = 0; i < nodes.length; ++i) {
            LinkedHashSet<NodeModel> nodeDependencies = new LinkedHashSet<NodeModel>(0);
            EvaluationDependencies.getEvaluationDependencies(nodes[i].getMap()).getDependencies(nodeDependencies, nodes[i]);
            if (nodeDependencies != null) {
                dependencies.addAll(nodeDependencies);
            }
            if (!includeChanged) continue;
            dependencies.add(nodes[i]);
        }
        return dependencies;
    }

    public static void accessNode(NodeModel accessingNode, NodeModel accessedNode) {
        EvaluationDependencies.getEvaluationDependencies(accessingNode.getMap()).accessNodeImpl(accessingNode, accessedNode);
    }

    public Set<NodeModel> getDependencies(Set<NodeModel> result, NodeModel node) {
        HashSet<NodeModel> onNode = this.onNodeDependencies.get(node);
        if (onNode != null) {
            this.addRecursively(result, onNode);
        }
        return result;
    }

    private void addRecursively(Set<NodeModel> dependentNodes, HashSet<NodeModel> nodesToAdd) {
        for (NodeModel node : nodesToAdd) {
            if (!dependentNodes.add(node)) continue;
            dependentNodes.addAll(this.getDependencies(dependentNodes, node));
        }
    }

    private void accessNodeImpl(NodeModel formulaNode, NodeModel accessedNode) {
        this.getDependencySet(accessedNode, this.onNodeDependencies).add(formulaNode);
    }

    private HashSet<NodeModel> getDependencySet(NodeModel accessedNode, HashMap<NodeModel, HashSet<NodeModel>> dependenciesMap) {
        HashSet<NodeModel> set = dependenciesMap.get(accessedNode);
        if (set == null) {
            set = new HashSet();
            dependenciesMap.put(accessedNode, set);
        }
        return set;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        for (Map.Entry<NodeModel, HashSet<NodeModel>> entry : this.onNodeDependencies.entrySet()) {
            builder.append("onNode (" + entry.getKey().getText() + "):\n");
            for (NodeModel nodeModel : entry.getValue()) {
                builder.append("  " + nodeModel + "\n");
            }
        }
        return builder.toString();
    }
}

