/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.icon.factory;

import java.net.URL;
import java.util.WeakHashMap;
import javax.swing.ImageIcon;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.features.icon.UIIcon;

public final class ImageIconFactory {
    private static final ImageIconFactory FACTORY = new ImageIconFactory();
    private static final String DEFAULT_IMAGE_PATH = "/images/";
    private static final ImageIcon ICON_NOT_FOUND = new ImageIcon(ResourceController.getResourceController().getResource("/images/IconNotFound.png"));
    private final WeakHashMap<URL, ImageIcon> ICON_CACHE = new WeakHashMap();

    public static ImageIconFactory getInstance() {
        return FACTORY;
    }

    public ImageIcon getImageIcon(UIIcon uiIcon) {
        return this.getImageIcon(uiIcon.getUrl());
    }

    public ImageIcon getImageIcon(URL url) {
        ImageIcon result = ICON_NOT_FOUND;
        if (url != null) {
            if (this.ICON_CACHE.containsKey(url)) {
                result = this.ICON_CACHE.get(url);
            } else {
                result = new ImageIcon(url);
                this.ICON_CACHE.put(url, result);
            }
        }
        return result;
    }
}

