/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.icon;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.freeplane.features.icon.UIIcon;

public class ZoomedIcon
extends UIIcon {
    private static final Map<UIIcon, Map<Float, ImageIcon>> zoomedIcons = new HashMap<UIIcon, Map<Float, ImageIcon>>();
    private final UIIcon uiIcon;
    private final float zoom;
    private ImageIcon zoomedIcon;

    public ZoomedIcon(UIIcon uiIcon, float zoom) {
        super(uiIcon.getName(), uiIcon.getFileName(), uiIcon.getDescription(), uiIcon.getShortcutKey());
        this.uiIcon = uiIcon;
        this.zoom = zoom;
    }

    public Icon getIcon() {
        if (this.zoomedIcon == null) {
            Map<Float, ImageIcon> icons = zoomedIcons.get(this.uiIcon);
            if (icons == null) {
                icons = new HashMap<Float, ImageIcon>();
                zoomedIcons.put(this.uiIcon, icons);
            }
            this.zoomedIcon = icons.get(Float.valueOf(this.zoom));
            if (this.zoomedIcon != null) {
                return this.zoomedIcon;
            }
            Icon icon = this.uiIcon.getIcon();
            int width = icon.getIconWidth();
            int height = icon.getIconHeight();
            BufferedImage image = new BufferedImage(width, height, 2);
            Graphics2D g = image.createGraphics();
            icon.paintIcon(null, g, 0, 0);
            Image scaledImage = image.getScaledInstance((int)((float)width * this.zoom), (int)((float)height * this.zoom), 4);
            this.zoomedIcon = new ImageIcon(scaledImage);
            icons.put(Float.valueOf(this.zoom), this.zoomedIcon);
            g.dispose();
        }
        return this.zoomedIcon;
    }

    public String getPath() {
        return this.uiIcon.getPath();
    }

    public URL getUrl() {
        return this.uiIcon.getUrl();
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.zoom == ((ZoomedIcon)obj).zoom;
    }

    public int hashCode() {
        return 31 * super.hashCode() + Float.valueOf(this.zoom).hashCode();
    }
}

