/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.icon;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.swing.Icon;
import org.freeplane.core.ui.components.MultipleImage;
import org.freeplane.features.icon.UIIcon;
import org.freeplane.features.icon.ZoomedIcon;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UIIconSet
extends UIIcon {
    final Collection<UIIcon> uiIcons;
    final float zoom;
    List<Icon> imageIcons;
    private MultipleImage compoundIcon;

    public Collection<UIIcon> getIcons() {
        return this.uiIcons;
    }

    public UIIconSet(Collection<UIIcon> uiIcons, float zoom) {
        super("", "");
        this.zoom = zoom;
        this.uiIcons = Collections.unmodifiableCollection(uiIcons);
        this.imageIcons = new LinkedList<Icon>();
        for (UIIcon uiIcon : uiIcons) {
            Icon icon = zoom == 1.0f ? uiIcon.getIcon() : new ZoomedIcon(uiIcon, zoom).getIcon();
            this.imageIcons.add(icon);
        }
    }

    @Override
    public Icon getIcon() {
        if (this.compoundIcon == null) {
            this.compoundIcon = new MultipleImage();
            for (Icon icon : this.imageIcons) {
                this.compoundIcon.addImage(icon);
            }
        }
        return this.compoundIcon;
    }

    @Override
    public int compareTo(UIIcon uiIcon) {
        return 1;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        UIIconSet uiIconSet = (UIIconSet)obj;
        return this.zoom == uiIconSet.zoom && this.uiIcons.equals(uiIconSet.uiIcons);
    }

    @Override
    public int hashCode() {
        return 31 * this.uiIcons.hashCode();
    }
}

