/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.icon;

import java.net.URL;
import java.util.regex.Pattern;
import javax.swing.Icon;
import javax.swing.KeyStroke;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.features.icon.IIconInformation;
import org.freeplane.features.icon.factory.ImageIconFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UIIcon
implements IIconInformation,
Comparable<UIIcon> {
    private static final String DEFAULT_IMAGE_PATH = "/images";
    protected static final String SEPARATOR = "/";
    protected static final String THEME_FOLDER_KEY = "icon.theme.folder";
    protected static final ResourceController RESOURCE_CONTROLLER = ResourceController.getResourceController();
    private static final Pattern parentDirPattern = Pattern.compile("/[^/.]+/\\.\\./");
    private final String name;
    private final String fileName;
    private final String description;
    private final String shortcutKey;
    private URL resourceURL;

    public UIIcon(String name, String fileName) {
        this(name, fileName, "", "?");
    }

    public UIIcon(String name, String fileName, String description) {
        this(name, fileName, description, "?");
    }

    public UIIcon(String name, String fileName, String description, String shortcutKey) {
        this.name = name;
        this.fileName = fileName;
        this.description = description;
        this.shortcutKey = shortcutKey;
    }

    public String getFileName() {
        return this.fileName;
    }

    @Override
    public String getShortcutKey() {
        return this.shortcutKey;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public Icon getIcon() {
        return ImageIconFactory.getInstance().getImageIcon(this);
    }

    @Override
    public KeyStroke getKeyStroke() {
        return null;
    }

    public String getImagePath() {
        return DEFAULT_IMAGE_PATH;
    }

    public URL getUrl() {
        if (this.resourceURL != null) {
            return this.resourceURL;
        }
        String path = this.getPath();
        this.resourceURL = RESOURCE_CONTROLLER.getResource(path);
        return this.resourceURL;
    }

    public String getPath() {
        StringBuilder builder = new StringBuilder();
        builder = new StringBuilder();
        builder.append(this.getImagePath());
        builder.append(SEPARATOR);
        builder.append(this.fileName);
        String path = parentDirPattern.matcher(builder.toString()).replaceFirst(SEPARATOR);
        return path;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.description == null ? 0 : this.description.hashCode());
        result = 31 * result + (this.fileName == null ? 0 : this.fileName.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.shortcutKey == null ? 0 : this.shortcutKey.hashCode());
        result = 31 * result + this.getClass().hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        UIIcon other = (UIIcon)obj;
        if (this.description == null ? other.description != null : !this.description.equals(other.description)) {
            return false;
        }
        if (this.fileName == null ? other.fileName != null : !this.fileName.equals(other.fileName)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return !(this.shortcutKey == null ? other.shortcutKey != null : !this.shortcutKey.equals(other.shortcutKey));
    }

    @Override
    public int compareTo(UIIcon uiIcon) {
        return this.getPath().compareTo(uiIcon.getPath());
    }

    public String toString() {
        return this.name;
    }
}

