/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.icon;

import javax.swing.ComboBoxEditor;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import org.freeplane.core.resources.NamedObject;
import org.freeplane.core.util.TextUtils;
import org.freeplane.features.filter.condition.ASelectableCondition;
import org.freeplane.features.filter.condition.IElementaryConditionController;
import org.freeplane.features.icon.IconStore;
import org.freeplane.features.icon.MindIcon;
import org.freeplane.features.icon.PriorityCompareCondition;
import org.freeplane.features.icon.factory.IconStoreFactory;
import org.freeplane.n3.nanoxml.XMLElement;

class PriorityConditionController
implements IElementaryConditionController {
    static final String FILTER_PRIORITY = "filter_priority";
    private static final IconStore STORE = IconStoreFactory.create();

    public boolean canEditValues(Object property, NamedObject simpleCond) {
        return false;
    }

    public boolean canHandle(Object selectedItem) {
        if (!(selectedItem instanceof NamedObject)) {
            return false;
        }
        NamedObject namedObject = (NamedObject)selectedItem;
        return namedObject.objectEquals(FILTER_PRIORITY);
    }

    public boolean canSelectValues(Object property, NamedObject simpleCond) {
        return true;
    }

    public ASelectableCondition createCondition(Object selectedItem, NamedObject simpleCondition, Object valueObj, boolean matchCase, boolean matchApproximately) {
        String value = ((MindIcon)valueObj).getName().substring(5, 6);
        if (simpleCondition.objectEquals("filter_is_equal_to")) {
            return new PriorityCompareCondition(value, 0, true);
        }
        if (simpleCondition.objectEquals("filter_is_not_equal_to")) {
            return new PriorityCompareCondition(value, 0, false);
        }
        if (simpleCondition.objectEquals(">")) {
            return new PriorityCompareCondition(value, 1, true);
        }
        if (simpleCondition.objectEquals(">=")) {
            return new PriorityCompareCondition(value, -1, false);
        }
        if (simpleCondition.objectEquals("<")) {
            return new PriorityCompareCondition(value, -1, true);
        }
        if (simpleCondition.objectEquals("<=")) {
            return new PriorityCompareCondition(value, 1, false);
        }
        return null;
    }

    public ComboBoxModel getConditionsForProperty(Object selectedItem) {
        return new DefaultComboBoxModel<NamedObject>(new NamedObject[]{TextUtils.createTranslatedString("filter_is_equal_to"), TextUtils.createTranslatedString("filter_is_not_equal_to"), NamedObject.literal(">"), NamedObject.literal(">="), NamedObject.literal("<="), NamedObject.literal("<")});
    }

    public ListModel getFilteredProperties() {
        DefaultListModel<NamedObject> list = new DefaultListModel<NamedObject>();
        list.addElement(TextUtils.createTranslatedString(FILTER_PRIORITY));
        return list;
    }

    public ComboBoxEditor getValueEditor(Object selectedProperty, NamedObject selectedCondition) {
        return null;
    }

    public ComboBoxModel getValuesForProperty(Object property, NamedObject simpleCond) {
        Object[] items = new Object[10];
        for (int i = 1; i < 10; ++i) {
            items[i - 1] = STORE.getMindIcon("full-" + Integer.toString(i));
        }
        DefaultComboBoxModel<Object> box = new DefaultComboBoxModel<Object>(items);
        return box;
    }

    public boolean isCaseDependent(Object property, NamedObject simpleCond) {
        return false;
    }

    public boolean supportsApproximateMatching(Object property, NamedObject simpleCond) {
        return false;
    }

    public ASelectableCondition loadCondition(XMLElement element) {
        if (element.getName().equalsIgnoreCase("priority_compare_condition")) {
            return PriorityCompareCondition.load(element);
        }
        return null;
    }

    public ListCellRenderer getValueRenderer(Object selectedProperty, NamedObject selectedCondition) {
        return null;
    }
}

