/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.icon;

import java.util.Collection;
import javax.swing.JComponent;
import javax.swing.JLabel;
import org.freeplane.core.io.xml.TreeXmlReader;
import org.freeplane.core.io.xml.TreeXmlWriter;
import org.freeplane.core.util.TextUtils;
import org.freeplane.features.filter.condition.ASelectableCondition;
import org.freeplane.features.filter.condition.CompareConditionAdapter;
import org.freeplane.features.filter.condition.JCondition;
import org.freeplane.features.icon.IconController;
import org.freeplane.features.icon.IconStore;
import org.freeplane.features.icon.MindIcon;
import org.freeplane.features.icon.factory.IconStoreFactory;
import org.freeplane.features.map.NodeModel;
import org.freeplane.n3.nanoxml.XMLElement;

public class PriorityCompareCondition
extends CompareConditionAdapter {
    static final String COMPARATION_RESULT = "COMPARATION_RESULT";
    static final String NAME = "priority_compare_condition";
    static final String SUCCEED = "SUCCEED";
    static final String VALUE = "VALUE";
    private static final IconStore STORE = IconStoreFactory.create();
    private final int comparationResult;
    private final boolean succeed;

    static ASelectableCondition load(XMLElement element) {
        return new PriorityCompareCondition(element.getAttribute(VALUE, null), Integer.parseInt(element.getAttribute(COMPARATION_RESULT, null)), TreeXmlReader.xmlToBoolean(element.getAttribute(SUCCEED, null)));
    }

    PriorityCompareCondition(String value, int comparationResult, boolean succeed) {
        super(value, false, false);
        this.comparationResult = comparationResult;
        this.succeed = succeed;
    }

    public boolean isEqualityCondition() {
        return this.comparationResult == 0;
    }

    protected JComponent createRendererComponent() {
        JCondition renderer = new JCondition();
        String string = this.toString();
        JLabel label = new JLabel(string.substring(0, string.length() - 3));
        label.setIcon(STORE.getMindIcon(this.getIconName()).getIcon());
        label.setHorizontalTextPosition(2);
        renderer.add(label);
        return renderer;
    }

    public boolean checkNode(NodeModel node) {
        Collection<MindIcon> icons = IconController.getController().getIcons(node);
        for (MindIcon icon : icons) {
            String iconName = icon.getFileName();
            if (iconName.length() != 10 || !iconName.startsWith("full-") || iconName.charAt(5) < '0' || iconName.charAt(5) > '9') continue;
            String prio = iconName.substring(5, 6);
            this.compareTo(prio);
            return this.isComparisonOK() && this.succeed == (this.getComparisonResult() == this.comparationResult);
        }
        return false;
    }

    protected String createDescription() {
        String priorityCondition = TextUtils.getText("filter_priority");
        return super.createDescription(priorityCondition, this.comparationResult, this.succeed);
    }

    private String getIconName() {
        return "full-" + this.getConditionValue().toString();
    }

    public void fillXML(XMLElement child) {
        super.fillXML(child);
        child.setAttribute(COMPARATION_RESULT, Integer.toString(this.comparationResult));
        child.setAttribute(SUCCEED, TreeXmlWriter.BooleanToXml(this.succeed));
    }

    protected String getName() {
        return NAME;
    }
}

