/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.icon;

import javax.swing.ListModel;
import org.freeplane.core.extension.IExtension;
import org.freeplane.core.util.collection.SortedComboBoxModel;
import org.freeplane.features.icon.MindIcon;
import org.freeplane.features.icon.UIIcon;
import org.freeplane.features.map.MapController;
import org.freeplane.features.map.MapModel;
import org.freeplane.features.map.NodeModel;

public class IconRegistry
implements IExtension {
    private final SortedComboBoxModel mapIcons = new SortedComboBoxModel();

    public IconRegistry(MapController mapController, MapModel map) {
        NodeModel rootNode = map.getRootNode();
        if (rootNode != null) {
            this.registryNodeIcons(mapController, rootNode);
        }
    }

    public void addIcon(UIIcon icon) {
        this.mapIcons.add(icon);
    }

    public ListModel getIconsAsListModel() {
        return this.mapIcons;
    }

    private void registryNodeIcons(MapController mapController, NodeModel node) {
        for (MindIcon icon : node.getIcons()) {
            this.addIcon(icon);
        }
        for (NodeModel child : mapController.childrenUnfolded(node)) {
            this.registryNodeIcons(mapController, child);
        }
    }

    public void addIcons(MapModel map) {
        IconRegistry newRegistry = map.getIconRegistry();
        SortedComboBoxModel newMapIcons = newRegistry.mapIcons;
        for (Object uiIcon : newMapIcons) {
            this.mapIcons.add(uiIcon);
        }
    }
}

