/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.icon;

import java.awt.Color;
import java.util.Collection;
import javax.swing.JComponent;
import javax.swing.JLabel;
import org.freeplane.core.util.TextUtils;
import org.freeplane.features.filter.condition.ASelectableCondition;
import org.freeplane.features.filter.condition.JCondition;
import org.freeplane.features.icon.IconController;
import org.freeplane.features.icon.IconStore;
import org.freeplane.features.icon.MindIcon;
import org.freeplane.features.icon.UIIcon;
import org.freeplane.features.icon.factory.IconStoreFactory;
import org.freeplane.features.map.NodeModel;
import org.freeplane.n3.nanoxml.XMLElement;

public class IconContainedCondition
extends ASelectableCondition {
    private static final IconStore STORE = IconStoreFactory.create();
    static final String ICON = "ICON";
    static final String NAME = "icon_contained_condition";
    private final String iconName;

    private static int iconFirstIndex(NodeModel node, String iconName) {
        Collection<MindIcon> icons = IconController.getController().getIcons(node);
        int i = 0;
        for (MindIcon nextIcon : icons) {
            if (iconName.equals(nextIcon.getName())) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private static boolean isStateIconContained(NodeModel node, String iconName) {
        Collection<UIIcon> stateIcons = IconController.getController().getStateIcons(node);
        for (UIIcon stateIcon : stateIcons) {
            if (!iconName.equals(stateIcon.getName())) continue;
            return true;
        }
        return false;
    }

    static ASelectableCondition load(XMLElement element) {
        return new IconContainedCondition(element.getAttribute(ICON, null));
    }

    public IconContainedCondition(String iconName) {
        this.iconName = iconName;
    }

    public boolean checkNode(NodeModel node) {
        return IconContainedCondition.iconFirstIndex(node, this.iconName) != -1 || IconContainedCondition.isStateIconContained(node, this.iconName);
    }

    private String getIconName() {
        return this.iconName;
    }

    public JComponent createRendererComponent() {
        JCondition component = new JCondition();
        String text = TextUtils.getText("filter_icon") + ' ' + TextUtils.getText("filter_contains") + ' ';
        component.add(new JLabel(text));
        JLabel icon = new JLabel(STORE.getUIIcon(this.getIconName()).getIcon());
        component.add(icon);
        icon.setBackground(Color.WHITE);
        icon.setOpaque(true);
        return component;
    }

    public void fillXML(XMLElement child) {
        child.setAttribute(ICON, this.iconName);
    }

    protected String createDescription() {
        return TextUtils.getText("filter_icon") + " \"" + this.getIconName() + "\"";
    }

    protected String getName() {
        return NAME;
    }
}

