/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.icon;

import javax.swing.ComboBoxEditor;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import org.freeplane.core.resources.NamedObject;
import org.freeplane.core.util.TextUtils;
import org.freeplane.core.util.collection.ExtendedComboBoxModel;
import org.freeplane.features.filter.condition.ASelectableCondition;
import org.freeplane.features.filter.condition.DefaultConditionRenderer;
import org.freeplane.features.filter.condition.IElementaryConditionController;
import org.freeplane.features.icon.IconContainedCondition;
import org.freeplane.features.icon.IconExistsCondition;
import org.freeplane.features.icon.UIIcon;
import org.freeplane.features.mode.Controller;
import org.freeplane.n3.nanoxml.XMLElement;

class IconConditionController
implements IElementaryConditionController {
    static final String FILTER_ICON = "filter_icon";

    public boolean canEditValues(Object property, NamedObject simpleCond) {
        return false;
    }

    public boolean canHandle(Object selectedItem) {
        if (!(selectedItem instanceof NamedObject)) {
            return false;
        }
        NamedObject namedObject = (NamedObject)selectedItem;
        return namedObject.objectEquals(FILTER_ICON);
    }

    public boolean canSelectValues(Object property, NamedObject simpleCond) {
        return !simpleCond.objectEquals("filter_exist");
    }

    public ASelectableCondition createCondition(Object selectedItem, NamedObject simpleCond, Object value, boolean matchCase, boolean approximateMatching) {
        if (simpleCond.objectEquals("filter_contains")) {
            return value instanceof UIIcon ? new IconContainedCondition(((UIIcon)value).getName()) : null;
        }
        if (simpleCond.objectEquals("filter_exist")) {
            return new IconExistsCondition();
        }
        return null;
    }

    public ComboBoxModel getConditionsForProperty(Object property) {
        return new DefaultComboBoxModel<Object>(this.getIconConditionNames());
    }

    public ListModel getFilteredProperties() {
        DefaultListModel<NamedObject> list = new DefaultListModel<NamedObject>();
        list.addElement(TextUtils.createTranslatedString(FILTER_ICON));
        return list;
    }

    public Object[] getIconConditionNames() {
        return new NamedObject[]{TextUtils.createTranslatedString("filter_contains"), TextUtils.createTranslatedString("filter_exist")};
    }

    public ComboBoxEditor getValueEditor(Object selectedProperty, NamedObject selectedCondition) {
        return null;
    }

    public ComboBoxModel getValuesForProperty(Object property, NamedObject simpleCond) {
        ListModel icons = Controller.getCurrentController().getMap().getIconRegistry().getIconsAsListModel();
        ExtendedComboBoxModel extendedComboBoxModel = new ExtendedComboBoxModel();
        extendedComboBoxModel.setExtensionList(icons);
        return extendedComboBoxModel;
    }

    public boolean isCaseDependent(Object property, NamedObject simpleCond) {
        return false;
    }

    public boolean supportsApproximateMatching(Object property, NamedObject simpleCond) {
        return false;
    }

    public ASelectableCondition loadCondition(XMLElement element) {
        if (element.getName().equalsIgnoreCase("icon_contained_condition")) {
            return IconContainedCondition.load(element);
        }
        if (element.getName().equalsIgnoreCase("icon_exists_condition")) {
            return IconExistsCondition.load(element);
        }
        return null;
    }

    public ListCellRenderer getValueRenderer(Object selectedProperty, NamedObject selectedCondition) {
        return new DefaultConditionRenderer("", true);
    }
}

