/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.icon;

import java.io.IOException;
import java.util.Collection;
import org.freeplane.core.io.IAttributeHandler;
import org.freeplane.core.io.IElementDOMHandler;
import org.freeplane.core.io.IElementWriter;
import org.freeplane.core.io.ITreeWriter;
import org.freeplane.core.io.ReadManager;
import org.freeplane.core.io.WriteManager;
import org.freeplane.features.icon.IconController;
import org.freeplane.features.icon.IconStore;
import org.freeplane.features.icon.MindIcon;
import org.freeplane.features.map.MapWriter;
import org.freeplane.features.map.NodeModel;
import org.freeplane.n3.nanoxml.XMLElement;

class IconBuilder
implements IElementDOMHandler,
IElementWriter {
    private final IconStore store;

    public IconBuilder(IconController iconController, IconStore icons) {
        this.store = icons;
    }

    public Object createElement(Object parent, String tag, XMLElement attributes) {
        if (tag.equals("icon")) {
            return new IconProperties();
        }
        return null;
    }

    public void endElement(Object parent, String tag, Object userObject, XMLElement dom) {
        if (parent instanceof NodeModel && tag.equals("icon")) {
            NodeModel node = (NodeModel)parent;
            IconProperties ip = (IconProperties)userObject;
            node.addIcon(this.store.getMindIcon(ip.iconName));
            return;
        }
    }

    private void registerAttributeHandlers(ReadManager reader) {
        reader.addAttributeHandler("icon", "BUILTIN", new IAttributeHandler(){

            public void setAttribute(Object userObject, String value) {
                IconProperties ip = (IconProperties)userObject;
                ip.iconName = value;
            }
        });
    }

    public void registerBy(ReadManager reader, WriteManager writer) {
        reader.addElementHandler("icon", this);
        this.registerAttributeHandlers(reader);
        writer.addElementWriter("node", this);
        writer.addElementWriter("stylenode", this);
    }

    public void setAttributes(String tag, Object node, XMLElement attributes) {
    }

    public void writeContent(ITreeWriter writer, Object element, String tag) throws IOException {
        boolean forceFormatting = Boolean.TRUE.equals(writer.getHint((Object)MapWriter.WriterHint.FORCE_FORMATTING));
        NodeModel node = (NodeModel)element;
        Collection<MindIcon> icons = forceFormatting ? IconController.getController().getIcons(node) : node.getIcons();
        for (MindIcon icon : icons) {
            XMLElement iconElement = new XMLElement();
            iconElement.setName("icon");
            iconElement.setAttribute("BUILTIN", icon.getName());
            writer.addElement((Object)node, iconElement);
        }
    }

    static class IconProperties {
        String iconName;

        IconProperties() {
        }
    }
}

