/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.icon;

import java.util.Map;
import org.freeplane.core.extension.IExtension;
import org.freeplane.core.io.IReadCompletionListener;
import org.freeplane.features.icon.AccumulatedIcons;
import org.freeplane.features.icon.HierarchicalIcons2;
import org.freeplane.features.icon.IStateIconProvider;
import org.freeplane.features.icon.IconController;
import org.freeplane.features.icon.UIIcon;
import org.freeplane.features.icon.UIIconSet;
import org.freeplane.features.map.IMapChangeListener;
import org.freeplane.features.map.INodeChangeListener;
import org.freeplane.features.map.MapChangeEvent;
import org.freeplane.features.map.MapModel;
import org.freeplane.features.map.NodeChangeEvent;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.mode.ModeController;
import org.freeplane.features.mode.NodeHookDescriptor;
import org.freeplane.features.mode.PersistentNodeHook;
import org.freeplane.features.styles.MapStyleModel;
import org.freeplane.n3.nanoxml.XMLElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NodeHookDescriptor(hookName="accessories/plugins/HierarchicalIcons.properties")
public class HierarchicalIcons
extends PersistentNodeHook
implements INodeChangeListener,
IMapChangeListener,
IReadCompletionListener,
IExtension {
    public static final String ICONS = "hierarchical_icons";
    private Mode mode = Mode.OR;

    public HierarchicalIcons() {
        this(Mode.OR);
        ModeController modeController = Controller.getCurrentModeController();
        IconController.getController(modeController).addStateIconProvider(new IStateIconProvider(){

            public UIIcon getStateIcon(NodeModel node) {
                AccumulatedIcons iconSet = node.getExtension(AccumulatedIcons.class);
                if (iconSet != null) {
                    return new UIIconSet(iconSet.getAccumulatedIcons(), 0.75f);
                }
                return null;
            }
        });
        new HierarchicalIcons2();
    }

    protected HierarchicalIcons(Mode mode) {
        this.mode = mode;
        ModeController modeController = Controller.getCurrentModeController();
        modeController.getMapController().getReadManager().addReadCompletionListener(this);
        modeController.getMapController().addNodeChangeListener(this);
        modeController.getMapController().addMapChangeListener(this);
    }

    @Override
    protected void add(NodeModel node, IExtension extension) {
        if (MapStyleModel.getExtension(node.getMap()) != null) {
            this.gatherLeavesAndSetStyle(node);
            this.gatherLeavesAndSetParentsStyle(node);
        }
        super.add(node, extension);
    }

    @Override
    protected IExtension createExtension(NodeModel node, XMLElement element) {
        return this;
    }

    private void gatherLeavesAndSetParentsStyle(NodeModel node) {
        if (node.getChildCount() == 0) {
            for (NodeModel parent = node.getParentNode(); parent != null; parent = parent.getParentNode()) {
                AccumulatedIcons.setStyleCheckForChange(parent, this.mode);
            }
            return;
        }
        for (NodeModel child : Controller.getCurrentModeController().getMapController().childrenUnfolded(node)) {
            this.gatherLeavesAndSetParentsStyle(child);
        }
    }

    private void gatherLeavesAndSetStyle(NodeModel node) {
        node.removeExtension(AccumulatedIcons.class);
        if (node.getChildCount() == 0) {
            AccumulatedIcons.setStyleCheckForChange(node, this.mode);
            return;
        }
        for (NodeModel child : Controller.getCurrentModeController().getMapController().childrenUnfolded(node)) {
            this.gatherLeavesAndSetStyle(child);
        }
    }

    @Override
    public void mapChanged(MapChangeEvent event) {
        MapModel map = event.getMap();
        if (map == null) {
            return;
        }
        NodeModel rootNode = map.getRootNode();
        if (!this.isActive(rootNode)) {
            return;
        }
        Object property = event.getProperty();
        if (!property.equals("MAP_STYLES")) {
            return;
        }
        this.gatherLeavesAndSetStyle(rootNode);
        this.gatherLeavesAndSetParentsStyle(rootNode);
    }

    @Override
    public void nodeChanged(NodeChangeEvent event) {
        NodeModel node = event.getNode();
        if (!this.isActive(node)) {
            return;
        }
        this.setStyleRecursive(node);
    }

    @Override
    public void onNodeDeleted(NodeModel parent, NodeModel child, int index) {
        if (!this.isActive(parent)) {
            return;
        }
        this.setStyleRecursive(parent);
    }

    @Override
    public void onNodeInserted(NodeModel parent, NodeModel child, int newIndex) {
        if (!this.isActive(parent)) {
            return;
        }
        this.setStyleRecursive(child);
    }

    @Override
    public void onNodeMoved(NodeModel oldParent, int oldIndex, NodeModel newParent, NodeModel child, int newIndex) {
        if (!this.isActive(newParent)) {
            return;
        }
        this.setStyleRecursive(oldParent);
        this.setStyleRecursive(child);
    }

    @Override
    public void onPreNodeDelete(NodeModel parent, NodeModel child, int index) {
    }

    @Override
    public void readingCompleted(NodeModel topNode, Map<String, String> newIds) {
        if (!topNode.containsExtension(this.getClass()) && !topNode.getMap().getRootNode().containsExtension(this.getClass())) {
            return;
        }
        this.gatherLeavesAndSetStyle(topNode);
        this.gatherLeavesAndSetParentsStyle(topNode);
    }

    @Override
    protected void remove(NodeModel node, IExtension extension) {
        this.removeIcons(node);
        super.remove(node, extension);
    }

    private void removeIcons(NodeModel node) {
        AccumulatedIcons icons = node.removeExtension(AccumulatedIcons.class);
        if (icons != null) {
            Controller.getCurrentModeController().getMapController().delayedNodeRefresh(node, ICONS, null, null);
            for (NodeModel child : Controller.getCurrentModeController().getMapController().childrenUnfolded(node)) {
                this.removeIcons(child);
            }
        }
    }

    private void setStyleRecursive(NodeModel node) {
        if (AccumulatedIcons.setStyleCheckForChange(node, this.mode) && node.getParentNode() != null) {
            this.setStyleRecursive(node.getParentNode());
        }
    }

    @Override
    public void onPreNodeMoved(NodeModel oldParent, int oldIndex, NodeModel newParent, NodeModel child, int newIndex) {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Mode {
        AND,
        OR;

    }
}

