/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.help;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Enumeration;
import javax.swing.JEditorPane;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.tree.DefaultMutableTreeNode;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.core.ui.AFreeplaneAction;
import org.freeplane.core.ui.MenuBuilder;
import org.freeplane.core.util.HtmlUtils;
import org.freeplane.core.util.MenuUtils;
import org.freeplane.core.util.TextUtils;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.mode.ModeController;
import org.freeplane.features.mode.mindmapmode.MModeController;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HotKeyInfoAction
extends AFreeplaneAction {
    private static final long serialVersionUID = 1L;

    public HotKeyInfoAction() {
        super("HotKeyInfoAction");
    }

    private String formatAsHtml(Enumeration<DefaultMutableTreeNode> children) {
        StringBuilder builder = new StringBuilder();
        builder.append("<html><head><style type=\"text/css\">  h1 { background-color: #B5C8DB; margin-bottom: 0px; margin-top: 1ex; }  h2 { background-color: #B5C8DB; margin-bottom: 0px; margin-top: 1ex; }  h3 { background-color: #B5C8DB; margin-bottom: 0px; margin-top: 1ex; }</head><body width=\"600\">");
        this.appendAsHtml(builder, children, "", 2);
        builder.append("</body></html>");
        return builder.toString();
    }

    private void appendAsHtml(StringBuilder builder, Enumeration<DefaultMutableTreeNode> children, String title, int level) {
        if (!title.equals("")) {
            builder.append("<h").append(level).append('>').append(title).append("</h").append(level).append('>');
        }
        this.appendChildrenAsHtml(builder, children, title, level);
    }

    private void appendChildrenAsHtml(StringBuilder builder, Enumeration<DefaultMutableTreeNode> children, String title, int level) {
        ArrayList<MenuUtils.MenuEntry> menuEntries = new ArrayList<MenuUtils.MenuEntry>();
        ArrayList<DefaultMutableTreeNode> submenus = new ArrayList<DefaultMutableTreeNode>();
        while (children.hasMoreElements()) {
            DefaultMutableTreeNode node = children.nextElement();
            if (node.isLeaf()) {
                menuEntries.add((MenuUtils.MenuEntry)node.getUserObject());
                continue;
            }
            submenus.add(node);
        }
        if (!menuEntries.isEmpty()) {
            builder.append("<table cellspacing=\"0\" cellpadding=\"0\">");
            for (MenuUtils.MenuEntry entry : menuEntries) {
                String keystroke = entry.getKeyStroke() == null ? "" : MenuUtils.formatKeyStroke(entry.getKeyStroke());
                builder.append(this.el("tr", this.el("td", entry.getLabel() + "&#xa0;") + this.el("td", keystroke) + this.el("td", entry.getToolTipText())));
            }
            builder.append("</table>");
        }
        for (DefaultMutableTreeNode node : submenus) {
            String subtitle = (level > 2 ? title + "&#8594;" : "") + String.valueOf(node.getUserObject());
            this.appendAsHtml(builder, node.children(), subtitle, level + 1);
        }
    }

    private String el(String name, String content) {
        return HtmlUtils.element(name, content);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        ModeController modeController = ResourceController.getResourceController().isApplet() ? Controller.getCurrentModeController() : MModeController.getMModeController();
        MenuBuilder menuBuilder = modeController.getUserInputListenerFactory().getMenuBuilder();
        DefaultMutableTreeNode menuEntryTree = MenuUtils.createAcceleratebleMenuEntryTree("/menu_bar", menuBuilder);
        String title = TextUtils.getText("hot_keys_table");
        String html = this.formatAsHtml(menuEntryTree.children());
        JEditorPane refPane = new JEditorPane("text/html", html);
        refPane.putClientProperty("JEditorPane.honorDisplayProperties", false);
        refPane.setCaretPosition(0);
        refPane.setEditable(false);
        Dimension preferredSize = refPane.getPreferredSize();
        JScrollPane scrollPane = new JScrollPane(refPane, 22, 31);
        scrollPane.setPreferredSize(new Dimension(preferredSize.width, 600));
        JOptionPane.showMessageDialog((Component)e.getSource(), scrollPane, title, 1);
    }
}

