/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.help;

import java.awt.event.ActionEvent;
import org.freeplane.core.extension.IExtension;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.features.help.AboutAction;
import org.freeplane.features.help.DocumentationAction;
import org.freeplane.features.help.FilePropertiesAction;
import org.freeplane.features.help.HotKeyInfoAction;
import org.freeplane.features.help.OnlineDocumentationAction;
import org.freeplane.features.help.OpenSourceForgeURLAction;
import org.freeplane.features.help.OpenURLAction;
import org.freeplane.features.mode.Controller;

public class HelpController
implements IExtension {
    public static HelpController getController() {
        return Controller.getCurrentController().getExtension(HelpController.class);
    }

    public static void install() {
        Controller controller = Controller.getCurrentController();
        controller.addExtension(HelpController.class, new HelpController());
    }

    public HelpController() {
        Controller controller = Controller.getCurrentController();
        ResourceController resourceController = ResourceController.getResourceController();
        controller.addAction(new AboutAction());
        controller.addAction(new OpenURLAction("OpenFreeplaneSiteAction", resourceController.getProperty("webFreeplaneLocation")));
        if (resourceController.isApplet()) {
            return;
        }
        controller.addAction(new FilePropertiesAction());
        controller.addAction(new OpenSourceForgeURLAction("ReportBugAction", resourceController.getProperty("bugTrackerLocation")));
        controller.addAction(new OpenSourceForgeURLAction("RequestFeatureAction", resourceController.getProperty("featureTrackerLocation")));
        controller.addAction(new OpenSourceForgeURLAction("AskForHelp", resourceController.getProperty("helpForumLocation")));
        controller.addAction(new OpenURLAction("WebDocuAction", resourceController.getProperty("webDocuLocation")));
        String defaultMap = resourceController.getProperty("docu_map");
        controller.addAction(new DocumentationAction("DocumentationAction", defaultMap));
        String tutorialMap = resourceController.getProperty("tutorial_map");
        controller.addAction(new DocumentationAction("GettingStartedAction", tutorialMap));
        controller.addAction(new HotKeyInfoAction());
        controller.addAction(new OnlineDocumentationAction("OnlineReference", "docu-online"));
    }

    public void webDocu(ActionEvent e) {
        Controller.getCurrentController().getAction("WebDocuAction").actionPerformed(e);
    }
}

