/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.help;

import java.awt.event.ActionEvent;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.SwingUtilities;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.core.ui.AFreeplaneAction;
import org.freeplane.core.ui.components.UITools;
import org.freeplane.core.util.ConfigurationUtils;
import org.freeplane.core.util.LogUtils;
import org.freeplane.core.util.TextUtils;
import org.freeplane.features.map.mindmapmode.MMapController;
import org.freeplane.features.mode.Controller;

class DocumentationAction
extends AFreeplaneAction {
    private static final long serialVersionUID = 1L;
    private final String document;

    DocumentationAction(String actionName, String document) {
        super(actionName);
        this.document = document;
    }

    public void actionPerformed(ActionEvent e) {
        ResourceController resourceController = ResourceController.getResourceController();
        File userDir = new File(resourceController.getFreeplaneUserDirectory());
        File baseDir = new File(resourceController.getInstallationBaseDir());
        String languageCode = resourceController.getLanguageCode();
        File file = ConfigurationUtils.getLocalizedFile(new File[]{userDir, baseDir}, this.document, languageCode);
        if (file == null) {
            String name = (String)this.getValue("Name");
            String errorMessage = TextUtils.format("invalid_file_msg", name);
            UITools.errorMessage(errorMessage);
            return;
        }
        try {
            final URL endUrl = file.toURL();
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    try {
                        if (endUrl.getFile().endsWith(".mm")) {
                            Controller.getCurrentController().selectMode("MindMap");
                            ((MMapController)Controller.getCurrentModeController().getMapController()).newDocumentationMap(endUrl);
                        } else {
                            Controller.getCurrentController().getViewController().openDocument(endUrl);
                        }
                    }
                    catch (Exception e1) {
                        LogUtils.severe(e1);
                    }
                }
            });
        }
        catch (MalformedURLException e1) {
            LogUtils.warn(e1);
        }
    }

    public void afterMapChange(Object newMap) {
    }
}

