/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.help;

import java.awt.event.ActionEvent;
import java.net.URI;
import java.net.URISyntaxException;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.core.ui.AFreeplaneAction;
import org.freeplane.core.ui.components.UITools;
import org.freeplane.core.util.Compat;
import org.freeplane.core.util.FreeplaneVersion;
import org.freeplane.core.util.TextUtils;

class AboutAction
extends AFreeplaneAction {
    private static final long serialVersionUID = 1L;

    AboutAction() {
        super("AboutAction");
    }

    public void actionPerformed(ActionEvent e) {
        Box box = Box.createVerticalBox();
        String about = TextUtils.getText("about_text") + " " + FreeplaneVersion.getVersion();
        this.addUri(box, "homepage_url", about);
        this.addUri(box, "copyright_url", TextUtils.getText("copyright"));
        this.addMessage(box, FreeplaneVersion.getVersion().getRevision());
        this.addFormattedMessage(box, "java_version", Compat.JAVA_VERSION);
        this.addFormattedMessage(box, "main_resource_directory", ResourceController.getResourceController().getResourceBaseDir());
        this.addUri(box, "license_url", TextUtils.getText("license"));
        this.addMessage(box, TextUtils.getText("license_text"));
        JOptionPane.showMessageDialog(UITools.getFrame(), box, TextUtils.getText("AboutAction.text"), 1);
    }

    private void addFormattedMessage(Box box, String format, String parameter) {
        box.add(new JLabel(TextUtils.format(format, parameter)));
    }

    private void addMessage(Box box, String localMessage) {
        box.add(new JLabel(localMessage));
    }

    private void addUri(Box box, String uriProperty, String message) {
        try {
            URI uri = new URI(ResourceController.getResourceController().getProperty(uriProperty));
            JButton uriButton = UITools.createHtmlLinkStyleButton(uri, message);
            uriButton.setHorizontalAlignment(10);
            box.add(uriButton);
        }
        catch (URISyntaxException e1) {
            // empty catch block
        }
    }
}

