/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.format;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.freeplane.core.util.TextUtils;
import org.freeplane.features.format.Parser;
import org.freeplane.n3.nanoxml.XMLElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Scanner {
    private static final String ELEM_SCANNER = "scanner";
    private static final String ATTRIB_LOCALE = "locale";
    private static final String ATTRIB_DEFAULT = "default";
    private static final String ELEM_CHECKFIRSTCHAR = "checkfirstchar";
    private static final String ATTRIB_DISABLED = "disabled";
    private static final String ATTRIB_CHARS = "chars";
    private final ArrayList<String> locales;
    private final boolean isDefault;
    private String firstChars;
    private boolean checkFirstChars;
    private ArrayList<Parser> parsers = new ArrayList();

    public Scanner(String[] locales, boolean isDefault) {
        this.locales = new ArrayList<String>(Arrays.asList(locales));
        this.isDefault = isDefault;
        this.validate();
    }

    private void validate() {
        if (this.locales.isEmpty()) {
            throw new IllegalArgumentException("attribute locale is mandatory and may not be empty");
        }
    }

    public ArrayList<String> getLocales() {
        return this.locales;
    }

    public boolean isDefault() {
        return this.isDefault;
    }

    public String getFirstChars() {
        return this.firstChars;
    }

    public void setFirstChars(String firstChars) {
        this.firstChars = firstChars;
        this.checkFirstChars = !TextUtils.isEmpty(firstChars);
    }

    public void addParser(Parser parser) {
        this.parsers.add(parser);
    }

    public List<Parser> getParsers() {
        return new ArrayList<Parser>(this.parsers);
    }

    public XMLElement toXml() {
        XMLElement xmlElement = new XMLElement(ELEM_SCANNER);
        xmlElement.setAttribute(ATTRIB_LOCALE, StringUtils.join(this.locales.iterator(), (String)","));
        if (this.isDefault) {
            xmlElement.setAttribute(ATTRIB_DEFAULT, "true");
        }
        xmlElement.addChild(this.firstCharsToXml());
        for (Parser parser : this.parsers) {
            xmlElement.addChild(parser.toXml());
        }
        return xmlElement;
    }

    private XMLElement firstCharsToXml() {
        XMLElement xmlElement = new XMLElement(ELEM_CHECKFIRSTCHAR);
        if (this.checkFirstChars) {
            xmlElement.setAttribute(ATTRIB_CHARS, this.firstChars);
        } else {
            xmlElement.setAttribute(ATTRIB_DISABLED, "true");
        }
        return xmlElement;
    }

    public boolean localeMatchesExactly(String locale) {
        return this.locales.contains(locale);
    }

    public boolean countryMatches(String locale) {
        return this.locales.contains(locale.replaceFirst("_.*", ""));
    }

    public Object parse(String string) {
        if (TextUtils.isEmpty(string) || this.checkFirstChars && this.firstChars.indexOf(string.charAt(0)) == -1) {
            return string;
        }
        if (string.charAt(0) == '\'') {
            return string;
        }
        for (Parser parser : this.parsers) {
            Object object = parser.parse(string);
            if (object == null) continue;
            return object;
        }
        return string;
    }
}

