/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.format;

import org.freeplane.core.util.FactoryMethod;
import org.freeplane.core.util.LogUtils;
import org.freeplane.core.util.SerializationMethod;
import org.freeplane.core.util.TextUtils;
import org.freeplane.core.util.TypeReference;
import org.freeplane.features.format.IFormattedObject;
import org.freeplane.features.format.PatternFormat;

@FactoryMethod(value="deserialize")
@SerializationMethod(value="serialize")
public class FormattedObject
implements IFormattedObject {
    private final Object object;
    private final String formattedString;
    private final PatternFormat patternFormat;

    public FormattedObject(Object value, String format) {
        this(value, PatternFormat.guessPatternFormat(format));
    }

    public FormattedObject(Object object, PatternFormat format) {
        this.patternFormat = format;
        this.object = object;
        this.validate();
        this.formattedString = String.valueOf(this.patternFormat.formatObject(object));
    }

    private void validate() {
        if (this.patternFormat == null) {
            throw new IllegalArgumentException(TextUtils.getText("format_invalid_pattern"));
        }
    }

    public String getPattern() {
        return this.patternFormat.getPattern();
    }

    public Object getObject() {
        return this.object;
    }

    public static String serialize(FormattedObject formattedObject) {
        return FormattedObject.serializeUnformattedObject(formattedObject) + "|" + formattedObject.patternFormat.serialize();
    }

    private static String serializeUnformattedObject(FormattedObject formattedObject) {
        return TypeReference.encode(TypeReference.toSpec(formattedObject.object));
    }

    public static Object deserialize(String text) {
        try {
            int index = text.indexOf(124);
            Object object = FormattedObject.deserializeUnformattedObject(text, index);
            return new FormattedObject(object, PatternFormat.deserialize(text.substring(index + 1)));
        }
        catch (Exception e) {
            LogUtils.warn("cannot deserialize " + text, e);
            return text;
        }
    }

    private static Object deserializeUnformattedObject(String text, int index) {
        String spec = text.substring(0, index);
        return TypeReference.create(TypeReference.decode(spec), false);
    }

    public String toString() {
        return this.formattedString;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.patternFormat == null ? 0 : this.patternFormat.hashCode());
        result = 31 * result + (this.object == null ? 0 : this.object.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FormattedObject other = (FormattedObject)obj;
        if (this.patternFormat == null ? other.patternFormat != null : !this.patternFormat.equals(other.patternFormat)) {
            return false;
        }
        return !(this.object == null ? other.object != null : !this.object.equals(other.object));
    }
}

