/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.format;

import org.freeplane.core.util.FactoryMethod;
import org.freeplane.core.util.LogUtils;
import org.freeplane.core.util.SerializationMethod;
import org.freeplane.features.format.IFormattedObject;

@FactoryMethod(value="deserialize")
@SerializationMethod(value="serialize")
public class FormattedFormula
implements IFormattedObject {
    private static final String BAR = "@B@A@R@";
    private final String formula;
    private final String pattern;

    public FormattedFormula(String formula, String pattern) {
        this.formula = formula;
        this.pattern = pattern;
    }

    public String getPattern() {
        return this.pattern;
    }

    public String getObject() {
        return this.formula;
    }

    public static String serialize(FormattedFormula formattedObject) {
        return FormattedFormula.encodeBar(formattedObject.formula) + "|" + formattedObject.pattern;
    }

    public static Object deserialize(String text) {
        try {
            int index = text.indexOf(124);
            String formula = FormattedFormula.decodeBar(text.substring(0, index));
            return new FormattedFormula(formula, text.substring(index + 1));
        }
        catch (Exception e) {
            LogUtils.warn("cannot deserialize " + text, e);
            return text;
        }
    }

    private static String encodeBar(String formulaText) {
        return formulaText.replace("|", BAR);
    }

    private static String decodeBar(String formulaText) {
        return formulaText.replace(BAR, "|");
    }

    public String toString() {
        return this.formula;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.formula == null ? 0 : this.formula.hashCode());
        result = 31 * result + (this.pattern == null ? 0 : this.pattern.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FormattedFormula other = (FormattedFormula)obj;
        if (this.formula == null ? other.formula != null : !this.formula.equals(other.formula)) {
            return false;
        }
        return !(this.pattern == null ? other.pattern != null : !this.pattern.equals(other.pattern));
    }
}

