/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.format;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.Format;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.Vector;
import org.apache.commons.lang.StringUtils;
import org.freeplane.core.extension.IExtension;
import org.freeplane.core.resources.IFreeplanePropertyListener;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.core.resources.components.IValidator;
import org.freeplane.core.ui.components.UITools;
import org.freeplane.core.util.FileUtils;
import org.freeplane.core.util.LogUtils;
import org.freeplane.core.util.TextUtils;
import org.freeplane.features.format.DatePatternFormat;
import org.freeplane.features.format.DecimalPatternFormat;
import org.freeplane.features.format.FormatUtils;
import org.freeplane.features.format.FormattedDate;
import org.freeplane.features.format.FormattedFormula;
import org.freeplane.features.format.FormattedNumber;
import org.freeplane.features.format.FormattedObject;
import org.freeplane.features.format.FormatterPatternFormat;
import org.freeplane.features.format.IFormattedObject;
import org.freeplane.features.format.PatternFormat;
import org.freeplane.features.format.ScannerController;
import org.freeplane.features.mode.Controller;
import org.freeplane.n3.nanoxml.IXMLParser;
import org.freeplane.n3.nanoxml.StdXMLReader;
import org.freeplane.n3.nanoxml.XMLElement;
import org.freeplane.n3.nanoxml.XMLParserFactory;
import org.freeplane.n3.nanoxml.XMLWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FormatController
implements IExtension,
IFreeplanePropertyListener {
    private static final String RESOURCES_NUMBER_FORMAT = "number_format";
    private static final String RESOURCES_DATETIME_FORMAT = "datetime_format";
    private static final String RESOURCES_DATE_FORMAT = "date_format";
    private static final String FORMATS_XML = "formats.xml";
    private static final String ROOT_ELEMENT = "formats";
    private String pathToFile;
    private Locale locale;
    private List<PatternFormat> specialFormats = new ArrayList<PatternFormat>();
    private List<PatternFormat> dateFormats = new ArrayList<PatternFormat>();
    private List<PatternFormat> numberFormats = new ArrayList<PatternFormat>();
    private List<PatternFormat> stringFormats = new ArrayList<PatternFormat>();
    private boolean formatsLoaded;
    private SimpleDateFormat defaultDateFormat;
    private SimpleDateFormat defaultDateTimeFormat;
    private HashMap<String, SimpleDateFormat> dateFormatCache = new HashMap();
    private DecimalFormat defaultNumberFormat;
    private HashMap<String, DecimalFormat> numberFormatCache = new HashMap();
    private static boolean firstError = true;

    public IValidator createValidator() {
        return new IValidator(){

            public IValidator.ValidationResult validate(Properties properties) {
                IValidator.ValidationResult result = new IValidator.ValidationResult();
                try {
                    FormatController.createDateFormat(properties.getProperty(FormatController.RESOURCES_DATE_FORMAT));
                    if (properties.getProperty(FormatController.RESOURCES_DATE_FORMAT).isEmpty()) {
                        throw new Exception();
                    }
                }
                catch (Exception e) {
                    result.addError(TextUtils.getText("OptionPanel.validate_invalid_date_format"));
                }
                try {
                    FormatController.this.createDefaultDateTimeFormat(properties.getProperty(FormatController.RESOURCES_DATETIME_FORMAT));
                    if (properties.getProperty(FormatController.RESOURCES_DATETIME_FORMAT).isEmpty()) {
                        throw new Exception();
                    }
                }
                catch (Exception e) {
                    result.addError(TextUtils.getText("OptionPanel.validate_invalid_datetime_format"));
                }
                try {
                    FormatController.this.getDecimalFormat(properties.getProperty(FormatController.RESOURCES_NUMBER_FORMAT));
                    if (properties.getProperty(FormatController.RESOURCES_NUMBER_FORMAT).isEmpty()) {
                        throw new Exception();
                    }
                }
                catch (Exception e) {
                    result.addError(TextUtils.getText("OptionPanel.validate_invalid_number_format"));
                }
                return result;
            }
        };
    }

    public FormatController() {
        String freeplaneUserDirectory = ResourceController.getResourceController().getFreeplaneUserDirectory();
        this.pathToFile = freeplaneUserDirectory == null ? null : freeplaneUserDirectory + File.separator + FORMATS_XML;
        this.locale = FormatUtils.getFormatLocaleFromResources();
        this.initPatternFormats();
        ResourceController resourceController = ResourceController.getResourceController();
        resourceController.addPropertyChangeListener(this);
    }

    public static FormatController getController() {
        return FormatController.getController(Controller.getCurrentController());
    }

    public static FormatController getController(Controller controller) {
        return controller.getExtension(FormatController.class);
    }

    public static void install(FormatController formatController) {
        Controller.getCurrentController().addExtension(FormatController.class, formatController);
        Controller.getCurrentController().addOptionValidator(formatController.createValidator());
    }

    private void initPatternFormats() {
        block6: {
            if (this.formatsLoaded) {
                return;
            }
            this.specialFormats.add(PatternFormat.getStandardPatternFormat());
            this.specialFormats.add(PatternFormat.getIdentityPatternFormat());
            try {
                if (this.pathToFile != null) {
                    this.loadFormats();
                }
            }
            catch (Exception e) {
                LogUtils.warn(e);
                if (!firstError) break block6;
                firstError = false;
                UITools.errorMessage(TextUtils.getText("formats_not_loaded"));
            }
        }
        if (this.numberFormats.isEmpty() && this.dateFormats.isEmpty() && this.stringFormats.isEmpty()) {
            this.addStandardFormats();
            if (this.pathToFile != null) {
                this.saveFormatsNoThrow();
            }
        }
        this.formatsLoaded = true;
    }

    private void addStandardFormats() {
        String number = "number";
        this.numberFormats.add(this.createFormat("#0.####", "decimal", number, "default number", this.locale));
        this.numberFormats.add(this.createFormat("#.00", "decimal", number, "decimal", this.locale));
        this.numberFormats.add(this.createFormat("#", "decimal", number, "integer", this.locale));
        this.numberFormats.add(this.createFormat("#.##%", "decimal", number, "percent", this.locale));
        String dType = "date";
        String dStyle = "date";
        this.dateFormats.add(this.createLocalPattern("short date", 3, null));
        this.dateFormats.add(this.createLocalPattern("medium date", 2, null));
        this.dateFormats.add(this.createLocalPattern("short datetime", 3, 3));
        this.dateFormats.add(this.createLocalPattern("medium datetime", 2, 3));
        this.dateFormats.add(this.createFormat("yyyy-MM-dd", "date", dType, "short iso date", this.locale));
        this.dateFormats.add(this.createFormat("yyyy-MM-dd HH:mm", "date", dType, "long iso date", this.locale));
        this.dateFormats.add(this.createFormat("yyyy-MM-dd'T'HH:mmZ", "date", dType, "full iso date", this.locale));
        this.dateFormats.add(this.createFormat("HH:mm", "date", dType, "time", this.locale));
    }

    private PatternFormat createLocalPattern(String name, int dateStyle, Integer timeStyle) {
        SimpleDateFormat simpleDateFormat = (SimpleDateFormat)(timeStyle == null ? SimpleDateFormat.getDateInstance(dateStyle, this.locale) : SimpleDateFormat.getDateTimeInstance(dateStyle, timeStyle, this.locale));
        String dStyle = "date";
        String dType = "date";
        return this.createFormat(simpleDateFormat.toPattern(), "date", "date", name, this.locale);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadFormats() throws Exception {
        BufferedInputStream inputStream = null;
        File configXml = new File(this.pathToFile);
        if (!configXml.exists()) {
            LogUtils.info(this.pathToFile + " does not exist yet");
            return;
        }
        try {
            IXMLParser parser = XMLParserFactory.createDefaultXMLParser();
            inputStream = new BufferedInputStream(new FileInputStream(configXml));
            StdXMLReader reader = new StdXMLReader(inputStream);
            parser.setReader(reader);
            XMLElement loader = (XMLElement)parser.parse();
            Vector<XMLElement> formats = loader.getChildren();
            for (XMLElement elem : formats) {
                String type = elem.getAttribute("type", null);
                String style = elem.getAttribute("style", null);
                String name = elem.getAttribute("name", null);
                String locale = elem.getAttribute("locale", null);
                String content = elem.getContent();
                if (StringUtils.isEmpty((String)type) || StringUtils.isEmpty((String)style) || StringUtils.isEmpty((String)content)) {
                    throw new RuntimeException("wrong format in " + configXml + ": none of the following must be empty: type=" + type + ", style=" + style + ", element content=" + content);
                }
                PatternFormat format = this.createFormat(content, style, type, name, locale == null ? null : new Locale(locale));
                if (type.equals("date")) {
                    this.dateFormats.add(format);
                    continue;
                }
                if (type.equals("number")) {
                    this.numberFormats.add(format);
                    continue;
                }
                if (type.equals("string")) {
                    this.stringFormats.add(format);
                    continue;
                }
                if (type.equals("standard")) continue;
                throw new RuntimeException("unknown type in " + configXml + ": type=" + type + ", style=" + style + ", element content=" + content);
            }
        }
        catch (IOException e) {
            try {
                LogUtils.warn("error parsing " + configXml, e);
            }
            catch (Throwable throwable) {
                FileUtils.silentlyClose(inputStream);
                throw throwable;
            }
            FileUtils.silentlyClose(inputStream);
        }
        FileUtils.silentlyClose(inputStream);
    }

    private void saveFormatsNoThrow() {
        try {
            this.saveFormats(this.getAllFormats());
        }
        catch (Exception e) {
            LogUtils.warn("cannot create " + this.pathToFile, e);
        }
    }

    public void addPatternFormat(PatternFormat format) {
        this.specialFormats.add(format);
    }

    public ArrayList<PatternFormat> getAllFormats() {
        ArrayList<PatternFormat> formats = new ArrayList<PatternFormat>();
        formats.addAll(this.specialFormats);
        formats.addAll(this.numberFormats);
        formats.addAll(this.dateFormats);
        formats.addAll(this.stringFormats);
        return formats;
    }

    private void saveFormats(List<PatternFormat> formats) throws IOException {
        XMLElement saver = new XMLElement();
        saver.setName(ROOT_ELEMENT);
        String sep = System.getProperty("line.separator");
        String header = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>" + sep + "<!-- 'type' selects the kind of data the formatter is intended to format. -->" + sep + "<!-- 'style' selects the formatter implementation: -->" + sep + "<!--   - 'date': http://download.oracle.com/javase/6/docs/api/java/text/SimpleDateFormat.html -->" + sep + "<!--   - 'decimal': http://download.oracle.com/javase/6/docs/api/java/text/DecimalFormat.html -->" + sep + "<!--   - 'formatter': http://download.oracle.com/javase/6/docs/api/java/util/Formatter.html -->" + sep + "<!--   - 'name': a informal name, a comment that's not visible in the app -->" + sep + "<!--   - 'locale': the name of the locale, only set for locale dependent format codes -->" + sep;
        for (PatternFormat patternFormat : formats) {
            if (patternFormat.getType().equals("identity") || patternFormat.getType().equals("standard")) continue;
            saver.addChild(patternFormat.toXml());
        }
        FileWriter writer = new FileWriter(this.pathToFile);
        XMLWriter xmlWriter = new XMLWriter(writer);
        xmlWriter.addRawContent(header);
        xmlWriter.write(saver, true);
        ((Writer)writer).close();
    }

    public List<PatternFormat> getDateFormats() {
        return this.dateFormats;
    }

    public List<PatternFormat> getNumberFormats() {
        return this.numberFormats;
    }

    public List<PatternFormat> getStringFormats() {
        return this.stringFormats;
    }

    public List<String> getAllPatterns() {
        ArrayList<PatternFormat> formats = this.getAllFormats();
        ArrayList<String> result = new ArrayList<String>(formats.size());
        for (PatternFormat patternFormat : formats) {
            result.add(patternFormat.getPattern());
        }
        return result;
    }

    public static Object format(Object obj, String formatString, Object defaultObject) {
        try {
            PatternFormat format = PatternFormat.guessPatternFormat(formatString);
            if (obj == null) {
                return obj;
            }
            Object toFormat = FormatController.extractObject(obj);
            if (format == null) {
                return toFormat;
            }
            if (toFormat instanceof String) {
                String string = (String)toFormat;
                if (string.startsWith("=")) {
                    return new FormattedFormula(string, formatString);
                }
                ScannerController scannerController = ScannerController.getController();
                if (scannerController != null) {
                    toFormat = scannerController.parse(string);
                }
            }
            if (format.acceptsDate() && toFormat instanceof Date) {
                return new FormattedDate((Date)toFormat, formatString);
            }
            if (format.acceptsNumber() && toFormat instanceof Number) {
                return new FormattedNumber((Number)toFormat, formatString, format.formatObject(toFormat).toString());
            }
            return new FormattedObject(toFormat, format);
        }
        catch (Exception e) {
            return defaultObject;
        }
    }

    private static Object extractObject(Object obj) {
        return obj instanceof IFormattedObject ? ((IFormattedObject)obj).getObject() : obj;
    }

    public static Object format(Object obj, String formatString) {
        return FormatController.format(obj, formatString, obj);
    }

    public static Object formatUsingDefault(Object object) {
        if (object instanceof Date) {
            return FormatController.format(object, FormatController.getController().getDefaultDateTimeFormat().toPattern());
        }
        if (object instanceof Number) {
            return FormatController.format(object, FormatController.getController().getDefaultNumberFormat().toPattern());
        }
        return object;
    }

    public Format getDefaultFormat(String type) {
        if (type.equals("date")) {
            return this.getDefaultDateFormat();
        }
        if (type.equals("datetime")) {
            return this.getDefaultDateTimeFormat();
        }
        if (type.equals("number")) {
            return this.getDefaultNumberFormat();
        }
        throw new IllegalArgumentException("unknown format style");
    }

    public SimpleDateFormat getDefaultDateFormat() {
        if (this.defaultDateFormat != null) {
            return this.defaultDateFormat;
        }
        ResourceController resourceController = ResourceController.getResourceController();
        this.fixEmptyDataFormatProperty(resourceController, RESOURCES_DATE_FORMAT, "SHORT");
        String datePattern = resourceController.getProperty(RESOURCES_DATE_FORMAT);
        this.defaultDateFormat = FormatController.createDateFormat(datePattern);
        return this.defaultDateFormat;
    }

    private void fixEmptyDataFormatProperty(ResourceController resourceController, String resourceProperty, String defaultValue) {
        if (resourceController.getProperty(resourceProperty).isEmpty()) {
            resourceController.setProperty(resourceProperty, defaultValue);
        }
    }

    private static SimpleDateFormat createDateFormat(String datePattern) {
        Integer style = FormatController.getDateStyle(datePattern);
        if (style != null) {
            return (SimpleDateFormat)DateFormat.getDateInstance(style, FormatUtils.getFormatLocaleFromResources());
        }
        return new SimpleDateFormat(datePattern, FormatUtils.getFormatLocaleFromResources());
    }

    public SimpleDateFormat getDefaultDateTimeFormat() {
        if (this.defaultDateTimeFormat != null) {
            return this.defaultDateTimeFormat;
        }
        ResourceController resourceController = ResourceController.getResourceController();
        this.fixEmptyDataFormatProperty(resourceController, RESOURCES_DATETIME_FORMAT, "SHORT,SHORT");
        String datetimePattern = resourceController.getProperty(RESOURCES_DATETIME_FORMAT);
        this.defaultDateTimeFormat = this.createDefaultDateTimeFormat(datetimePattern);
        return this.defaultDateTimeFormat;
    }

    private SimpleDateFormat createDefaultDateTimeFormat(String datetimePattern) {
        String[] styles = datetimePattern.split("\\s*,\\s*");
        if (styles.length == 2 && FormatController.getDateStyle(styles[0]) != null && FormatController.getDateStyle(styles[1]) != null) {
            return (SimpleDateFormat)DateFormat.getDateTimeInstance(FormatController.getDateStyle(styles[0]), FormatController.getDateStyle(styles[1]), FormatUtils.getFormatLocaleFromResources());
        }
        return this.getDateFormat(datetimePattern);
    }

    private static Integer getDateStyle(String string) {
        if (string.equals("SHORT")) {
            return 3;
        }
        if (string.equals("MEDIUM")) {
            return 2;
        }
        if (string.equals("LONG")) {
            return 1;
        }
        if (string.equals("FULL")) {
            return 0;
        }
        return null;
    }

    public DecimalFormat getDefaultNumberFormat() {
        if (this.defaultNumberFormat != null) {
            return this.defaultNumberFormat;
        }
        ResourceController resourceController = ResourceController.getResourceController();
        this.fixEmptyDataFormatProperty(resourceController, RESOURCES_NUMBER_FORMAT, "#0.####");
        this.defaultNumberFormat = this.getDecimalFormat(resourceController.getProperty(RESOURCES_NUMBER_FORMAT));
        return this.defaultNumberFormat;
    }

    public DecimalFormat getDecimalFormat(String pattern) {
        DecimalFormat format = this.numberFormatCache.get(pattern);
        if (format == null) {
            format = pattern == null ? this.getDefaultNumberFormat() : new DecimalFormat(pattern, new DecimalFormatSymbols(FormatUtils.getFormatLocaleFromResources()));
            this.numberFormatCache.put(pattern, format);
        }
        return format;
    }

    public SimpleDateFormat getDateFormat(String pattern) {
        SimpleDateFormat parser = this.dateFormatCache.get(pattern);
        if (parser == null) {
            parser = new SimpleDateFormat(pattern, FormatUtils.getFormatLocaleFromResources());
            this.dateFormatCache.put(pattern, parser);
        }
        return parser;
    }

    @Override
    public void propertyChanged(String propertyName, String newValue, String oldValue) {
        if (propertyName.equals(RESOURCES_DATE_FORMAT)) {
            this.defaultDateFormat = FormatController.createDateFormat(newValue);
            ScannerController scannerController = ScannerController.getController();
            if (scannerController != null) {
                scannerController.addParsersForStandardFormats();
            }
        } else if (propertyName.equals(RESOURCES_DATETIME_FORMAT)) {
            this.defaultDateTimeFormat = this.createDefaultDateTimeFormat(newValue);
            ScannerController scannerController = ScannerController.getController();
            if (scannerController != null) {
                scannerController.addParsersForStandardFormats();
            }
        } else if (propertyName.equals(RESOURCES_NUMBER_FORMAT)) {
            this.defaultNumberFormat = this.getDecimalFormat(newValue);
        } else if (FormatUtils.equalsFormatLocaleName(propertyName)) {
            this.locale = FormatUtils.getFormatLocaleFromResources();
        }
    }

    public List<PatternFormat> getSpecialFormats() {
        return this.specialFormats;
    }

    public PatternFormat createFormat(String pattern, String style, String type) {
        for (PatternFormat specialFormat : this.specialFormats) {
            if (!pattern.equals(specialFormat.getPattern())) continue;
            return specialFormat;
        }
        if (style.equals("date")) {
            return new DatePatternFormat(pattern);
        }
        if (style.equals("formatter")) {
            return new FormatterPatternFormat(pattern, type);
        }
        if (style.equals("decimal")) {
            return new DecimalPatternFormat(pattern);
        }
        throw new IllegalArgumentException("unknown format style");
    }

    public PatternFormat createFormat(String pattern, String style, String type, String name, Locale locale) {
        PatternFormat format = this.createFormat(pattern, style, type, name);
        format.setLocale(locale);
        return format;
    }

    public PatternFormat createFormat(String pattern, String style, String type, String name) {
        PatternFormat format = this.createFormat(pattern, style, type);
        format.setName(name);
        return format;
    }
}

